<?php

namespace App\Controllers\admin;
// use App\models\Partners_model;
class Dashboard extends Admin
{
    public function __construct()
    {
        parent::__construct();
        $this->user_model = new \App\Models\Users_model();
        $this->orders = new \App\Models\Orders_model();
    }

    public function index()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $db = \Config\Database::connect();
            $ionAuth = new \IonAuth\Libraries\IonAuth();
            $id = $ionAuth->user()->row()->id;
            $admin = 1;
            $cust_id = 2;
            $partner_id = 3;

            $total_users = $db->table('users u')->select('count(u.id) as `total`')->get()->getResultArray()[0]['total'];

            $total_admin = $db->table('users_groups ug')->select('count(ug.group_id) as `total`')->where(['group_id' => $admin])->get()->getResultArray()[0]['total'];

            $total_cutsomers = $db->table('users_groups ug')->select('count(ug.group_id) as `total`')->where(['group_id' => $cust_id])->get()->getResultArray()[0]['total'];
            $total_partners = $db->table('users_groups ug')->select('count(ug.group_id) as `total`')->where(['group_id' => $partner_id])->get()->getResultArray()[0]['total'];



            $total_balance = $db->table('users u')->select('sum(u.balance) as `total`')->where(['id' => $id])->get()->getResultArray()[0]['total'];
            $total_on_sale = $db->table('offers of')->select('count(of.id) as `total`')->get()->getResultArray()[0]['total'];

            // service section
            $total_services = $db->table('services s')->select('count(s.id) as `total`')->get()->getResultArray()[0]['total'];

            $service_condition =  "created_at > CURRENT_DATE - INTERVAL 30 day";

            $new_services = $db->table('services s')->select('count(s.id) as `total`')->where($service_condition)->get()->getResultArray()[0]['total'];
            $total_on_sale_service = $db->table('services s')->select('count(s.id) as `total`')->where(['discounted_price >=' => 0])->get()->getResultArray()[0]['total'];

            $top_rated_service_condition = 'rating >= 4 and number_of_ratings >= 10';
            $total_top_rated = $db->table('services s')->select('count(s.id) as `total`')->where($top_rated_service_condition)->get()->getResultArray()[0]['total'];

            $available_services = $db->table('services s')->select('count(s.id) as `total`')->where('status', 1)->get()->getResultArray()[0]['total'];
            //  ends here 

            //  passing service data 
            $this->data['total_services'] = $total_services;
            $this->data['total_on_sale_service'] = $total_on_sale_service;
            $this->data['new_services'] = $new_services;
            $this->data['available_services'] = $available_services;
            // 

            // order related_data
            $total_orders = $db->table('orders o')->select('count(o.id) as `total`')->get()->getResultArray()[0]['total'];
            $total_awaiting = $db->table('orders o')->select('count(o.id) as `total`')->where(['status' => 'awaiting'])->get()->getResultArray()[0]['total'];
            $total_confirmed = $db->table('orders o')->select('count(o.id) as `total`')->where(['status' => 'confirmed'])->get()->getResultArray()[0]['total'];
            $total_completed = (!empty($db->table('orders o')->select('count(o.id) as `total`')->where(['status' => 'completed'])->get()->getResultArray())) ? $db->table('orders o')->select('count(o.id) as `total`')->where(['status' => 'completed'])->get()->getResultArray()[0]['total'] : 0;
            $total_rescheduled = (!empty($db->table('orders o')->select('count(o.id) as `total`')->where(['status' => 'rescheduled'])->get()->getResultArray())) ? $db->table('orders o')->select('count(o.id) as `total`')->where(['status' => 'rescheduled'])->get()->getResultArray()[0]['total'] : 0;
            $total_cancelled = (!empty($db->table('orders o')->select('count(o.id) as `total`')->where(['status' => 'cancelled'])->get()->getResultArray())) ? $db->table('orders o')->select('count(o.id) as `total`')->where(['status' => 'cancelled'])->get()->getResultArray()[0]['total'] : 0;

            

            //             
            // echo "<pre>";
            $earning =  $db
                ->table('orders o')
                ->select('
                       o.final_total, pd.admin_commission,
                        SUM(o.final_total - (( o.final_total * pd.admin_commission)/100)) as total_partner_earning,
                        SUM(( o.final_total * pd.admin_commission)/100) as total_admin_earning,
                        SUM(o.final_total) as total_earning
                ')
                ->join('partner_details pd', 'pd.partner_id = o.partner_id','left')
                ->get()->getResultArray();  
                
            $symbol =   get_currency();
            $this->data['title'] = 'Admin Panel';
            $this->data['total_admin'] = $total_admin;
            $this->data['total_customers'] = $total_cutsomers;
            $this->data['total_partners'] = $total_partners;
            $this->data['total_orders'] = $total_orders;
            $this->data['total_users']  = $total_users;
            $this->data['total_balance'] = $total_balance;
            $this->data['total_awaiting'] = $total_awaiting;
            $this->data['total_rescheduled'] = $total_rescheduled;
            $this->data['total_cancelled'] = $total_cancelled;
            $this->data['total_confirmed'] = $total_confirmed;
            $this->data['total_completed'] = $total_completed;
            $this->data['total_on_sale'] = $total_on_sale;
            $this->data['currency'] = $symbol;

            $this->data['total_top_rated'] = $total_top_rated;
            $this->data['admin_earning'] = (!empty($earning)) ? number_format($earning[0]['total_admin_earning'], 2, ".", "") : '00';
            $this->data['partner_earnings'] = (!empty($earning)) ? number_format($earning[0]['total_partner_earning'], 2, ".", "") : '00';
            $this->data['total_earning'] = (!empty($earning)) ? number_format($earning[0]['total_earning'], 2, ".", "") : '00';

            $this->data['main_page'] = 'dashboard';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }
    public function fetch_details()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $sales[] = array();
            $db = \Config\Database::connect();

            $month_total_earning = $db->table('orders o')
                ->select('sum(o.final_total) AS total_earning,DATE_FORMAT(created_at,"%b") AS month_name')
                ->where(['status' => 4])
                ->groupBy('year(CURDATE()),MONTH(created_at)')
                ->orderBy('year(CURDATE()),MONTH(created_at)')
                ->get()->getResultArray();
            $month_wise_earning['total_earning'] = array_map('intval', array_column($month_total_earning, 'total_earning'));
            $month_wise_earning['month_name'] = array_column($month_total_earning, 'month_name');
            $sales = $month_total_earning;
            print_r(json_encode($sales));
        }
    }
    public function list()
    {
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';

        print_r(json_encode($this->partner->list(false, $search, $limit, $offset, $sort, $order)));
    }
}
