<?php

namespace App\Controllers\admin;

use App\Models\Notification_model;

class Notification extends Admin
{
    public   $validation, $notification, $db;
    public function __construct()
    {
        parent::__construct();
        helper(['form', 'url']);
        $this->notification = new Notification_model();
        $this->validation = \Config\Services::validation();
        $this->db      = \Config\Database::connect();
    }
    public function index()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $this->data['title'] = 'Send Notification | Admin Panel';
            $this->data['main_page'] = 'notification';
            $this->data['categories_name'] = fetch_details('categories', [], ['id', 'name']);
            $this->data['users'] = fetch_details('users', [], ['id', 'username']);
            $this->data['notification'] = fetch_details('notifications');
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('unauthorised');
        }
    }
    public function add_notification()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }
            $type = ($this->request->getPost('type'));
                if (isset($type) && $type  == "personal") {
                    $this->validation->setRules(
                        [
                            'title' => [
                                "rules" => 'required|trim',
                                "errors" => [
                                    "required" => "Please enter title for notification"
                                ]
                            ],
                            'user_ids' => [
                                "rules" => 'required',
                                "errors" => [
                                    "required" => "Please select atleast one user",
                                ]
                            ],
                            'image' => [
                                "rules" => 'uploaded[image]|ext_in[image,png,jpg,gif,jpeg,webp]|max_size[image,8496]|is_image[image]'
                            ],
                            'message' => [
                                "rules" => 'required',
                                "errors" => [
                                    "required" => "Please enter message for notification"
                                ]
                            ],
                        ],
                    );
                } else {
                    $this->validation->setRules(
                        [
                            'type' => [
                                "rules" => 'required',
                                "errors" => [
                                    "required" => "Please select type of notification"
                                ]
                            ],
                            'title' => [
                                "rules" => 'required|trim',
                                "errors" => [
                                    "required" => "Please enter title for notification"
                                ]
                            ],
                            'image' => [
                                "rules" => 'uploaded[image]|ext_in[image,png,jpg,gif,jpeg,webp]|max_size[image,8496]|is_image[image]'
                            ],
                            'message' => [
                                "rules" => 'required',
                                "errors" => [
                                    "required" => "Please enter message for notification"
                                ]
                            ],
                        ],
                    );
                }

                if (!$this->validation->withRequest($this->request)->run()) {
                    $errors  = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;

                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];
                    return $this->response->setJSON($response);
                }
            $t = time();
            $name = $this->request->getPost('type');
            $image_data = $this->request->getFile('image');
            $image = ($image_data->getName() != "") ? $image_data : '';
            $title = $this->request->getPost('title');
            $message = $this->request->getPost('message');

            if ($name == "personal") {
                $user_ids['user_ids'] = implode(',', $_POST['user_ids']);
            } else {
                $id = "000";
            }

            // experiment section
            // getting server key here



            $ext = ($image != "") ? $image->getExtension() : '';
            $image_name = ($image != "") ? $t . '.' . $ext : '';
            // $image_name = $image->getName();
            $data['title'] = $title;
            $data['message'] = $message;
            $data['type'] = $name;
            $data['type_id'] = ($name == "general") ? "-" :  $user_ids['user_ids'] = implode(',', $_POST['user_ids']);
            $data['notification_type'] = ($name == "personal") ? "personal" : "general";
            if ($name == "general") {
                $data['notification_type'] = "general";
            } else {
                $data['notification_type'] = "personal";
            }


            $data['image'] = $image_name;
            $path = "/public/uploads/notification/";
            if ($ext != '') {
                move_file($image, $path, $image_name);
            }
            $fcm_server_key = get_settings('api_key_settings', true)['firebase_server_key'];
            if ($this->notification->save($data)) {
                if ($name == "personal") {
                    if ($name == "personal") {
                        $to_send_id = $_POST['user_ids'];

                        $builder = $this->db->table('users')->select('fcm_id');
                        $users_fcm = $builder->whereIn('id', $to_send_id)->get()->getResultArray();

                        if (empty($fcm_server_key)) {
                            $response = [
                                'error' => true,
                                'message' => "No FCM key Found Please provide server key",
                                'csrfName' => csrf_token(),
                                'csrfHash' => csrf_hash(),
                                'data' => []
                            ];
                            return $this->response->setJSON($response);
                        }


                        foreach ($users_fcm as $ids) {
                            if ($ids['fcm_id'] != "") {
                                $fcm_ids[] = $ids['fcm_id'];
                            }
                        }
                        $registrationIDs = $fcm_ids;
                        if ($ext != '') {
                            $fcmMsg = array(
                                'content_available' => true,
                                'title' => "$title",
                                'body' => "$message",
                                'type' => $name,
                                'type_id' => $data['type_id'],
                                'image' => 'https://bsmedia.business-standard.com/_media/bs/img/article/2022-07/13/full/1657695329-4111.PNG?im=Resize,width=640',
                                'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                            );
                        } else {
                            $fcmMsg = array(
                                'content_available' => true,
                                'title' => "$title",
                                'body' => "$message",
                                'type' => $name,
                                'type_id' => $data['type_id'],
                                'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                            );
                        }

                        $registrationIDs_chunks = array_chunk($registrationIDs, 1000);
                    }
                    $not_data =  send_notification($fcmMsg, $registrationIDs_chunks);

                    $response = [
                        'error' => false,
                        'message' => "Send notification successfully",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => [$not_data]
                    ];

                    return $this->response->setJSON($response);
                } else {

                    if (empty($fcm_server_key)) {
                        $response = [
                            'error' => true,
                            'message' => "No FCM key Found Please provide server key",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => []
                        ];
                        return $this->response->setJSON($response);
                    }
                    $where = "fcm_id is  NOT NULL";
                    $users_fcm = $this->db->table('users')->select('fcm_id')->where($where)->get()->getResultArray();
                    foreach ($users_fcm as $ids) {
                        if ($ids['fcm_id'] != "") {
                            $fcm_ids[] = $ids['fcm_id'];
                        }
                    }
                    $registrationIDs = $fcm_ids;
                    if ($ext != '') {
                        $fcmMsg = array(
                            'content_available' => true,
                            'title' => "$title",
                            'body' => "$message",
                            'type' => $name,
                            'type_id' => $data['type_id'],
                            'image' => 'https://bsmedia.business-standard.com/_media/bs/img/article/2022-07/13/full/1657695329-4111.PNG?im=Resize,width=640',
                            'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                        );
                    } else {
                        $fcmMsg = array(
                            'content_available' => true,
                            'title' => "$title",
                            'body' => "$message",
                            'type' => $name,
                            'type_id' => $data['type_id'],
                            'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                        );
                    }
                    $registrationIDs_chunks = array_chunk($registrationIDs, 1000);
                    $not_data =  send_notification($fcmMsg, $registrationIDs_chunks);
                    $response = [
                        'error' => false,
                        'message' => "Send notification successfully",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => [$not_data]
                    ];

                    return $this->response->setJSON($response);
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => "some error occurred",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            return redirect('admin/login');
        }
    }
    public function list()
    {
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';
        $data = $this->notification->list(false, $search, $limit, $offset, $sort, $order);
        return $data;
    }

    public function  delete_notification()
    {

        if ($this->isLoggedIn && $this->userIsAdmin) {
            if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                $response['error'] = true;
                $response['message'] = DEMO_MODE_ERROR;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                return $this->response->setJSON($response);
            }

            $id = $this->request->getPost('user_id');
            $icons = fetch_details('notifications', ['id' => $id]);
            $image = ($icons[0] != '') ? $icons[0]['image'] : '';
            $db      = \Config\Database::connect();
            $builder = $db->table('notifications');
            if ($builder->delete(['id' => $id])) {
                $path = ($image != "") ? "public/uploads/notification/" . $image : '';
                if ($image != "") {
                    unlink($path);
                }

                $response = [
                    'error' => false,
                    'message' => 'Category deleted successfully',
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => 'An error occured during deleting this item',
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            return redirect('admin/login');
        }
    }
}
