<?php

namespace App\Controllers\admin;

use App\Models\Partners_model;
use App\Models\Payment_request_model;
use App\Models\Users_model;
use App\Models\Service_ratings_model;
use IonAuth\Models\IonAuthModel;

class Partners extends Admin
{
    public $partner,  $validation, $db, $ionAuth, $creator_id;
    public function __construct()
    {
        parent::__construct();
        $this->partner = new Partners_model();
        $this->users = new Users_model();
        $this->validation = \Config\Services::validation();
        $this->db = \Config\Database::connect();
        $this->ionAuth = new \IonAuth\Libraries\IonAuth();
        $this->creator_id = $this->userId;
    }
    public function index()
    {
        helper('function');
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $this->data['title'] = 'Partners | Admin Panel';
            $this->data['main_page'] = 'partners';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }
    public function add_partner()
    {
       
        $permission = is_permitted($this->creator_id, 'create', 'partner');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $this->data['title'] = 'Add Partners | Admin Panel';
                $this->data['main_page'] = 'add_partner';
                $partner_details = !empty(fetch_details('partner_details', ['partner_id' => $this->userId])) ? fetch_details('partner_details', ['partner_id' => $this->userId])[0] : [];
                $partner_timings = !empty(fetch_details('partner_timings', ['partner_id' => $this->userId])) ? fetch_details('partner_timings', ['partner_id' => $this->userId]) : [];
                $this->data['data'] = fetch_details('users', ['id' => $this->userId])[0];
                $this->data['partner_details'] = $partner_details;
                $this->data['partner_timings'] = $partner_timings;
                $this->data['city_name'] = fetch_details('cities', [], ['id', 'name']);
                return view('backend/admin/template', $this->data);
            } else {
                return redirect('admin/login');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function list()
    {
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';

        print_r(json_encode($this->partner->list(false, $search, $limit, $offset, $sort, $order)));
    }

    public function view_partner()
    {
        helper('function');
        $uri = service('uri');
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $partner_id = $uri->getSegments()[3];
            // operations sections
            $data = fetch_details('partner_details', ['partner_id' => $partner_id]);
            if (empty($data)) {
                return redirect('admin/partners');
            }
            $partner_details = $data[0];
            $user_details = fetch_details('users', ['id' => $partner_id])[0];
            // $city_id = $user_details['city_id'];


            // $city_details = fetch_details('cities', ['id' => $city_id]);

            // passing data
            $this->data['title'] = 'Partners | Admin Panel';
            $this->data['partner_details'] = $partner_details;
            $this->data['personal_details'] = $user_details;
            $this->data['main_page'] = 'view_partner';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function insert_partner()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        $permission = is_permitted($this->creator_id, 'create', 'partner');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $t = time();

                $this->validation->setRules(
                    [
                        'company_name' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter company_name"
                            ]
                        ],
                        'city' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter city",
                            ]
                        ],
                        'address' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter address",
                            ]
                        ],
                        'partner_latitude' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please choose provider location",
                            ]
                        ],
                        'type' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please select provider's type",
                            ]
                        ],
                        'number_of_members' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter number of members",
                                "numeric" => "Please enter numeric value for members"
                            ]
                        ],
                        'visiting_charges' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter visiting charges",
                                "numeric" => "Please enter numeric value for visiting charges"
                            ]
                        ],
                        'advance_booking_days' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter advance booking days",
                                "numeric" => "Please enter numeric advance booking days"
                            ]
                        ],
                        'start_time' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter provider's working days",
                            ]
                        ],
                        'end_time' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter provider's working properly ",
                            ]
                        ],
                        'username' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter provider's name",
                            ]
                        ],
                        'email' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter provider's email",
                            ]
                        ],
                        'phone' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter provider's phone number",
                                "numeric" => "Please enter numeric phone number"
                            ]
                        ],
                        'password' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter password",
                            ]
                        ],
                        'admin_commission' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter admin commission",
                                "numeric" => "Please enter numeric admin commission"
                            ]
                        ],
                        'tax_name' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter tax_name",
                            ]
                        ],
                        'tax_number' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter admin tax number",
                            ]
                        ],
                        'account_number' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter account number",
                                "numeric" => "Please enter numeric account number"
                            ]
                        ],
                        'account_name' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter account name",
                            ]
                        ],
                        'bank_code' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter bank code",
                            ]
                        ],
                        'bank_name' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter bank name",
                            ]
                        ],
                        'swift_code' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter swift code",
                            ]
                        ],
                        'passport' => [
                            "rules" => 'uploaded[passport]|ext_in[image,png,jpg,gif,jpeg,webp]|max_size[image,8496]|is_image[image]'
                        ],
                        'national_id' => [
                            "rules" => 'uploaded[national_id]|ext_in[image,png,jpg,gif,jpeg,webp]|max_size[image,8496]|is_image[image]'
                        ],
                        
                    ],
                );
                if (!$this->validation->withRequest($this->request)->run()) {
                    $errors = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];

                    return $this->response->setJSON($response);
                }

                $ion_auth = new IonAuthModel();

                $username = trim($_POST['username']);
                $password = $_POST['password'];
                $email = strtolower($_POST['email']);
                $phone = $_POST['phone'];
                $city = $_POST['city'];
                $is_approved = $_POST['is_approved'];
                $partner_image = $this->request->getFile('image');
                $ext = $partner_image->getExtension();
                $image_name = $t . '.' . $ext;
                $users_details['username'] = $username;
                $users_details['password'] =  $ion_auth->hashPassword($password);
                $users_details['email'] = $email;
                $users_details['latitude'] = $this->request->getPost('partner_latitude');
                $users_details['longitude'] = $this->request->getPost('partner_longitude');
                $users_details['phone'] = $phone;
                $users_details['city'] = $city;
                $users_details['image'] = $image_name;
                $users_details['is_approved'] = $is_approved;
                $users_details['active'] = 1;
                $path = "/public/uploads/users/partners/";
                $insert_id = $this->users->save($users_details);

                if ($insert_id) {
                    move_file($partner_image, $path, $image_name);
                    $partner_id = $this->users->getInsertID();
                    // 
                    $banner_image = $this->request->getFile('banner_image');
                    $banner_name = $banner_image->getRandomName();
                    // 
                    $company_name = trim($_POST['company_name']);
                    $address = trim($_POST['address']);
                    $tax_name = $_POST['tax_name'];
                    $tax_number = $_POST['tax_number'];
                    $bank_name = $_POST['bank_name'];
                    $account_number = $_POST['account_number'];
                    $account_name = $_POST['account_name'];
                    $bank_code = $_POST['bank_code'];
                    $swift_code = $_POST['swift_code'];
                    $advance_booking_days = $_POST['advance_booking_days'];
                    $about = $_POST['about'];
                    $admin_commission = $_POST['admin_commission'];
                    $type = $_POST['type'];
                    $number_of_members = $_POST['number_of_members'];
                    $visiting_charges = $_POST['visiting_charges'];
                    $is_approved = $_POST['is_approved'];
                    $national_id_image = $this->request->getFile('national_id');
                    $ext1 = $national_id_image->getExtension();
                    $name_1 = $national_id_image->getName();
                    $image_name1 = $name_1 . '.' . $ext1;
                    $passport_image = $this->request->getFile('passport');
                    $ext2 = $passport_image->getExtension();
                    $image_name2 = $t . '.' . $ext2;
                    $path1 = "/public/uploads/users/national_id/";
                    $path2 = "/public/uploads/users/passport/";
                    $path3 = "/public/uploads/users/partners/banner_images/";

                    $partners['partner_id'] = $partner_id;
                    $partners['banner'] = $path3.$banner_name;   
                    $partners['company_name'] = $company_name;
                    $partners['national_id'] = $path1.$image_name1;
                    $partners['passport'] = $path2.$image_name2;
                    $partners['address'] = $address;
                    $partners['tax_name'] = $tax_name;
                    $partners['tax_number'] = $tax_number;
                    $partners['bank_name'] = $bank_name;
                    $partners['account_number'] = $account_number;
                    $partners['account_name'] = $account_name;
                    $partners['bank_code'] = $bank_code;
                    $partners['swift_code'] = $swift_code;
                    $partners['advance_booking_days'] = $advance_booking_days;
                    $partners['about'] = $about;
                    $partners['admin_commission'] = $admin_commission;
                    $partners['type'] = $type;
                    $partners['number_of_members'] = $number_of_members;
                    $partners['visiting_charges'] = $visiting_charges;
                    $partners['is_approved'] = $is_approved;

                    if ($this->partner->save($partners)) {
                        move_file($national_id_image, $path1, $name_1);
                        move_file($passport_image, $path2, $image_name2);
                        move_file($banner_image, $path3, $banner_name);
                   
                        $days = [
                            0 => 'monday',
                            1 => 'tuesday',
                            2 => 'wednesday',
                            3 => 'thursday',
                            4 => 'friday',
                            5 => 'saturday',
                            6 => 'sunday'
                        ];

                        for ($i = 0; $i < count($_POST['start_time']); $i++) {
                            $partner_timing = [];
                            $partner_timing['day'] = $days[$i];
                            if (isset($_POST['start_time'][$i])) {
                                $partner_timing['opening_time'] = $_POST['start_time'][$i];
                            }
                            if (isset($_POST['end_time'][$i])) {
                                $partner_timing['closing_time'] = $_POST['end_time'][$i];
                            }
                            $partner_timing['is_open'] = (isset($_POST[$days[$i]])) ? 1 : 0;
                            $partner_timing['partner_id'] = $partner_id;
                            insert_details($partner_timing, 'partner_timings');
                        }
                        // group inserting hre                            
                        if(!exists(["user_id" => $partner_id, "group_id" => 3 ],'users_groups')){
                            $group_data['user_id'] = $partner_id;
                            $group_data['group_id'] = 3;
                            insert_details($group_data, 'users_groups');
                        }
                        $response = [
                            'error' => false,
                            'message' => "Congratulations! Partner Added",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => []
                        ];
                        return $this->response->setJSON($response);
                    } else {
                        $response = [
                            'error' => true,
                            'message' => "some error while adding partner",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => []
                        ];
                        return $this->response->setJSON($response);
                    }
                } else {
                    $response = [
                        'error' => true,
                        'message' => "some error while addding partner",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                    // 


                }
            } else {
                return redirect('admin/login');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function deactivate_partner()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        $permission = is_permitted($this->creator_id, 'update', 'partner');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $partner_id = $this->request->getPost('partner_id');
                $partner_details = fetch_details('users', ['id' => $partner_id])[0];
                $operation =  $this->ionAuth->deactivate($partner_id);


                if ($operation) {
                    $response = [
                        'error' => false,
                        'message' => "successfully disabled",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => "unsuccessful attempt to disable the user",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                return redirect('admin/login');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function activate_partner()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        $permission = is_permitted($this->creator_id, 'update', 'partner');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $partner_id = $this->request->getPost('partner_id');
                $partner_details = fetch_details('users', ['id' => $partner_id])[0];
                $operation =  $this->ionAuth->activate($partner_id);

                if ($operation) {
                    $response = [
                        'error' => false,
                        'message' => "successfully activated",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => "unsuccessful attempt to disable the user",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                return redirect('admin/login');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function approve_partner()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        $permission = is_permitted($this->creator_id, 'update', 'partner');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $partner_id = $this->request->getPost('partner_id');
                $builder = $this->db->table('partner_details');
                $partner_approval = $builder->set('is_approved', 1)->where('partner_id', $partner_id)->update();
                $partner_details = fetch_details('partner_details', ['partner_id' => $partner_id])[0];


                if ($partner_approval) {
                    $response = [
                        'error' => false,
                        'message' => "Partner approved",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => [$partner_approval]
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => false,
                        'message' => "Could not approve partner",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => [$partner_approval]
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                return redirect('admin/login');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function disapprove_partner()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        $permission = is_permitted($this->creator_id, 'update', 'partner');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $partner_id = $this->request->getPost('partner_id');
                $builder = $this->db->table('partner_details');
                $partner_approval = $builder->set('is_approved', 0)->where('partner_id', $partner_id)->update();
                $partner_details = fetch_details('partner_details', ['partner_id' => $partner_id])[0];

                if ($partner_approval) {
                    $response = [
                        'error' => false,
                        'message' => "Partner is disapproved",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => [$partner_approval]
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => false,
                        'message' => "Could not disapprove partner",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => [$partner_approval]
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                return redirect('admin/login');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function delete_partner()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        $permission = is_permitted($this->creator_id, 'delete', 'partner');
        if ($permission) {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $partner_id = $this->request->getPost('partner_id');

                $service_details = fetch_details('services', ['user_id' => $partner_id]);
                $partner_timing_details = fetch_details('partner_timings', ['partner_id' => $partner_id]);
                $partner_details = fetch_details('partner_details', ['partner_id' => $partner_id]);
                $user_details = fetch_details('users', ['id' => $partner_id]);
                $user_group_details = fetch_details('users_groups', ['user_id' => $partner_id]);

                if (!empty($service_details)) {
                    $builder = $this->db->table('services');
                    $builder->delete(['user_id' => $partner_id]);
                }
                if (!empty($partner_timing_details)) {
                    $builder = $this->db->table('partner_timings');
                    $builder->delete(['partner_id' => $partner_id]);
                }
                if (!empty($user_group_details)) {
                    $builder = $this->db->table('users_groups');
                    $builder->delete(['user_id' => $partner_id]);
                }
                if (!empty($partner_details)) {
                    $builder = $this->db->table('partner_details');
                    $builder->delete(['partner_id' => $partner_id]);
                }

                
                if (!empty($user_details)) {
                    $builder = $this->db->table('users');
                    $partner_approval = $builder->delete(['id' => $partner_id]);
                    if ($partner_approval) {
                        $response = [
                            'error' => false,
                            'message' => "Partner is Removed",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => [$partner_approval]
                        ];
                        return $this->response->setJSON($response);
                    } else {
                        $response = [
                            'error' => false,
                            'message' => "Could not Delete partner",
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'data' => [$partner_approval]
                        ];
                        return $this->response->setJSON($response);
                    }
                }
            } else {
                return redirect('admin/login');
            }
        } else {
            $response = [
                'error' => true,
                'message' => "Sorry! you're not permitted to take this action",
                'csrfName' => csrf_token(),
                'csrfHash' => csrf_hash(),
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function payment_request()
    {
       
        helper('function');
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $this->data['title'] = 'Partners | Admin Panel';
            $this->data['main_page'] = 'payment_request';
            
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function payment_request_list()
    {

        $payment_requests = new Payment_request_model();
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';

        $data = $payment_requests->list(false, $search, $limit, $offset, $sort, $order);
        return $data;
    }

    public function pay_partner()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        $admin_id =  $this->userId;

        $pr_id = $this->request->getPost('request_id');
        $user_id = $this->request->getPost('user_id');
        $reason = $this->request->getPost('reason');
        $amount = $this->request->getPost('amount');
        $status = $this->request->getPost('status') == "approved" ? 1 : 2;

        $partner_details  = fetch_details('users', ['id' => $user_id]);
        $admin_details  = fetch_details('users', ['id' => $admin_id]);
        if ($status == 1) {
            if (!empty($partner_details)) {
                if ((int)$partner_details[0]['balance'] < (int)$amount) {
                    $response = [
                        'error' => true,
                        'message' => "requested amount is greater than partner's wallet balance",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }

                $update_request = update_details(
                    ['remarks' => $reason, 'status' => $status],
                    ['id' => $pr_id],
                    'payment_request'
                );
                $update_balance =  (int)$admin_details[0]['balance'] + $amount;
                $update_admin = update_details(
                    ['balance' => $update_balance],
                    ['id' => $admin_id],
                    'users'
                );
                if ($update_admin) {
                    $response = [
                        'error' => false,
                        'message' => "debited amount $amount",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            }
        } else {
            $update_balance =  (int)$partner_details[0]['balance'] + $amount;
            $update_id = update_details(['balance' => $update_balance], ['id' => $user_id], 'users');
            update_details(
                [
                    'remarks' => $reason,
                    'status' => $status
                ],
                ['id' => $pr_id],
                'payment_request'
            );
            if ($update_id) {
                $response = [
                    'error' => false,
                    'message' => "Rejection occurred",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => "some error occurred",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        }
    }

    public function delete_request()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $id = $this->request->getPost('id');

            $builder = $this->db->table('payment_request')->delete(['id' => $id]);
            if ($builder) {
                $response = [
                    'error' => false,
                    'message' => "Deleted payment request success",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => "Couldn't delete payment request",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            return redirect('admin/login');
        }
    }

    public function partner_details()
    {
        helper('function');
        $uri = service('uri');
        $partner_id = $uri->getSegments()[3];
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';

        print_r(json_encode($this->partner->list(false, $search, $limit, $offset, $sort, $order, ["pd.partner_id " => $partner_id])));
    }

    public function banking_details()
    {
        $uri = service('uri');
        $partner_id = $uri->getSegments()[3];


        $db      = \Config\Database::connect();
        $builder = $db->table('partner_details pd');
        $count = $builder->select('COUNT(pd.id) as total')
            ->where('pd.partner_id', $partner_id)->get()->getResultArray();
        $total = $count[0]['total'];
        $tempRow = array();
        $data =  $builder->select('pd.*, u.city')
            ->join('users u', 'u.id = pd.partner_id')
            // ->join('cities c', 'c.id = u.city_id')
            ->where('pd.partner_id', $partner_id)->get()->getResultArray();
        $rows = [];
        // print_r($data);
        foreach ($data as $row) {
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['name'] = $row['city'];
            $tempRow['passport'] = $row['passport'];
            $tempRow['tax_name'] = $row['tax_name'];
            $tempRow['tax_number'] = $row['tax_number'];
            $tempRow['bank_name'] = $row['bank_name'];
            $tempRow['account_number'] = $row['account_number'];
            $tempRow['account_name'] = $row['account_name'];
            $tempRow['bank_code'] = $row['bank_code'];
            $tempRow['swift_code'] = $row['swift_code'];

            $rows[] = $tempRow;
        }
        $bulkData['total'] = $total;
        $bulkData['rows'] = $rows;
        return json_encode($bulkData);
    }

    public function timing_details()
    {
        $uri = service('uri');
        $partner_id = $uri->getSegments()[3];


        $db      = \Config\Database::connect();
        $builder = $db->table('partner_timings pt');
        $count = $builder->select('COUNT(pt.id) as total')
            ->where('pt.partner_id', $partner_id)->get()->getResultArray();
        $total = $count[0]['total'];
        $tempRow = array();
        $data =  $builder->select('pt.*,')
            ->where('pt.partner_id', $partner_id)->get()->getResultArray();
        $rows = [];
        // print_r($data);
        foreach ($data as $row) {
            $label = ($row['is_open'] == 1) ?
                '<div class="badge badge-success projects-badge"> Open </div>' :
                '<div class="badge badge-danger projects-badge"> Closed </div>';
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['day'] = $row['day'];
            $tempRow['opening_time'] = $row['opening_time'];
            $tempRow['closing_time'] = $row['closing_time'];
            $tempRow['is_open'] = $label;

            $rows[] = $tempRow;
        }
        $bulkData['total'] = $total;
        $bulkData['rows'] = $rows;
        // print_r($bulkData['rows']);
        return json_encode($bulkData);
    }

    public function service_details()
    {
        $uri = service('uri');
        $partner_id = $uri->getSegments()[3];


        $db      = \Config\Database::connect();
        $builder = $db->table('services s');
        $count = $builder->select('COUNT(s.id) as total')
            ->where('s.user_id', $partner_id)->get()->getResultArray();
        $total = $count[0]['total'];
        $tempRow = array();
        $data =  $builder->select('s.*, c.name')
            ->join('categories c', 'c.id = category_id ')
            ->where('s.user_id', $partner_id)->get()->getResultArray();
        $rows = [];
        // print_r($data);
        foreach ($data as $row) {
            // Operations
            $on_site_allowed = ($row['on_site_allowed'] == 1) ?
                '<div class="badge badge-success projects-badge"> Yes </div>' :
                '<div class="badge badge-danger projects-badge"> No </div>';

            $is_cancelable = ($row['is_cancelable'] == 1) ?
                '<div class="badge badge-success projects-badge"> Yes </div>' :
                '<div class="badge badge-danger projects-badge"> No </div>';

            $is_pay_later_allowed = ($row['is_pay_later_allowed'] == 1) ?
                '<div class="badge badge-success projects-badge"> Yes </div>' :
                '<div class="badge badge-danger projects-badge"> No </div>';

            $status = ($row['status'] == 1) ?
                '<div class="badge badge-success projects-badge"> Available </div>' :
                '<div class="badge badge-danger projects-badge"> Not-Available  </div>';

            if (isset($row['image']) && !empty($row['image']) && check_exists(base_url($row['image']))) {
                $images = '<a  href="' . base_url($row['image'])  . '" data-lightbox="image-1"><img height="80px" class="rounded" src="' . base_url($row['image']) . '" alt=""></a>';
            } else {
                $images = 'nothing found';
            }

            $tempRow['partner_id'] = $row['user_id'];
            $tempRow['category_name'] = $row['name'];
            $tempRow['service_title'] = $row['title'];
            $tempRow['description'] = $row['description'];
            $tempRow['image'] = $images;
            $tempRow['duration'] = $row['duration'];
            $tempRow['on_site_allowed'] = $on_site_allowed;
            $tempRow['is_cancelable'] = $is_cancelable;
            $tempRow['cancelable_till'] = $row['cancelable_till'];
            $tempRow['max_quantity_allowed'] = $row['max_quantity_allowed'];
            $tempRow['is_pay_later_allowed'] = $is_pay_later_allowed;
            $tempRow['status'] = $status;


            $rows[] = $tempRow;
        }
        $bulkData['total'] = $total;
        $bulkData['rows'] = $rows;
        // print_r($bulkData['rows']);
        return json_encode($bulkData);
    }

    public function settle_commission()
    {
        helper('function');
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $this->data['title'] = 'Commission Settlement | Admin Panel';
            $this->data['main_page'] = 'manage_commission';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function commission_list()
    {
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';

        return json_encode($this->partner->unsettled_commission_list(false, $search, $limit, $offset, $sort, $order));
    }

    public function commission_pay_out()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $order_id  = $this->request->getPost('id');
            $partner_id = $this->request->getPost('partner_id');
            $amount = $this->request->getPost('amount');

            $current_balance = fetch_details('users', ['id' => $partner_id], ['balance'])[0];
         
            $this->validation->setRules(
                [
                    'amount' => [
                        "rules" => 'required|numeric|less_than['.$current_balance['balance'].']',
                        "errors" => [
                            "required" => "Please enter commission",
                            "numeric" => "Please enter numeric value for commission",
                            "less_than" => "Amount must be less than current balance",
                        ]
                    ],
                ],
            );

            if (!$this->validation->withRequest($this->request)->run()) {
                $errors  = $this->validation->getErrors();
                $response['error'] = true;
                $response['message'] = $errors;

                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['data'] = [];
                return $this->response->setJSON($response);
            }

            $updated_balance = $current_balance['balance'] - $amount;
            $update = update_details(['balance' => $updated_balance], ['id' => $partner_id], 'users');
            $t = time();
            $data = [
                'transaction_type' => 'transaction',
                'user_id' => $this->userId,
                'partner_id' => $partner_id,
                'order_id' =>  "TXN-$t",
                'type' => 'fund_transfer',
                'txn_id' => '',
                'amount' =>  $amount,
                'status' => 'success',
                'currency_code' => NULL,
                'message' => 'commission settled'
            ];
            if ($update) {
                if (add_transaction($data)) {
                    $response = [
                        'error' => false,
                        'message' => "Commission Settled Successfully",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => "Unsuccessful while adding transaction",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => "Unsuccessful while Updating settling status",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            return redirect('admin/login');
        }
    }

    public function view_ratings()
    {

        $uri = service('uri');
        $partner_id = $uri->getSegments()[3];
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $ratings_model = new Service_ratings_model();
            $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
            $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
            $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
            $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
            $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';

            $data =  $ratings_model->ratings_list(false, $search, $limit, $offset, $sort, $order, ['s.user_id' => $partner_id]);
            return json_encode($ratings_model->ratings_list(false, $search, $limit, $offset, $sort, $order, ['s.user_id' => $partner_id]));
        } else {
            return redirect('admin/login');
        }
    }

    public function delete_rating()
    {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
            $response['error'] = true;
            $response['message'] = DEMO_MODE_ERROR;
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $this->response->setJSON($response);
        }
        if ($this->isLoggedIn && $this->userIsAdmin) {
            $id = $this->request->getPost('id');
            $data = $this->db->table('services_ratings')->delete(['id' => $id]);
            if ($data) {
                $response = [
                    'error' => false,
                    'message' => "Rating deleted successfully",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => "unsuccessful in deletion of rating",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            return redirect('admin/login');
        }
    }
}
