<?php

namespace App\Controllers\partner\api;

use App\Controllers\BaseController;
use App\Models\Orders_model;
use App\Models\Partners_model;
use App\Models\Category_model;
use App\Models\Payment_request_model;
use App\Models\Promo_code_model;
use App\Models\Service_model;
use App\Models\Tax_model;
use App\Libraries\Paystack;
use App\Libraries\Razorpay;
use App\Models\Slider_model;
use App\Libraries\Stripe;
use App\Libraries\Flutterwave;
use App\Models\Transaction_model;
use App\Models\Service_ratings_model;
use App\Models\Notification_model;

use DateTime;

/*  
1. 
i.login
 ii.Register /update both done
2  get_orders // token jose   done
4. i.get_categories 
ii. get_sub_categories //both done
5. get_services // done token jose
6. get_transactions //done token jose
7. get_statistics //done token jose
9. delete_orders // done token jose 
10. verify_user //done
11. get_settings  //done
12. update_fcm //done
13. get_taxes // done
14. send_withdrawal_request //done token jose
15. get_withdrawal_request //done token jose
24. delete_withdrawal_request //done token jose
17. get_partner //done  token jose
19. delete_service //done token jose
21. update_service_status //done token jose
22. manage_promocode //done token jose
23. delete_promocode //done token jose
24. get_promocodes //done token jose
25. manage_service //done

3. update_order_status // token jose
8. forgot_password 
20. reset_password

*/

class V1 extends BaseController
{

    protected $excluded_routes =
    [
        "/partner/api/v1/index",
        "/partner/api/v1",
        "/partner/api/v1/manage_user",
        "/partner/api/v1/register",
        "/partner/api/v1/forgot_password",
        "/partner/api/v1/login",
        "/partner/api/v1/verify_user",
        "/partner/api/v1/get_settings",

    ];
    private  $user_details = [];
    private  $allowed_settings = ["general_settings", "terms_conditions", "privacy_policy", "about_us"];
    private  $user_data = ['id', 'first_name', 'last_name', 'phone', 'email', 'fcm_id', 'image'];

    function __construct()
    {

        helper('api');
        helper("function");
        $this->request = \Config\Services::request();
        $current_uri =  uri_string();
        if (!in_array($current_uri, $this->excluded_routes)) {
            $token = verify_app_request();
            // print_r($token);
            if ($token['error']) {
                header('Content-Type: application/json');
                http_response_code($token['status']);
                print_r(json_encode($token));
                die();
            }
            $this->user_details = $token['data'];
        } else {
            // check if the token has been sent even if it is excluded. then set the user details if found.
            $token = verify_app_request();
            if (!$token['error'] && isset($token['data']) && !empty($token['data'])) {
                $this->user_details = $token['data'];
            }
        }
    }


    // 1.
    public function index()
    {
        $response = \Config\Services::response();
        helper("filesystem");
        $response->setHeader('content-type', 'Text');
        return $response->setBody(file_get_contents(base_url('api-doc.txt')));
    }

    public function login()
    {
        /* 
            mobile : 1234567890
            password : 12345678
        */
        $ionAuth = new \IonAuth\Libraries\IonAuth();
        $config = new \Config\IonAuth();
        $validation =  \Config\Services::validation();
        $request = \Config\Services::request();
        $identity_column = $config->identity;
        // 

        if ($identity_column == 'phone') {
            $identity = $request->getPost('mobile');
            $validation->setRule('mobile', 'Mobile', 'numeric|required');
        } elseif ($identity_column == 'email') {
            $identity = $request->getPost('email');
            $validation->setRule('email', 'Email', 'required|valid_email');
        } else {
            $validation->setRule('identity', 'Identity', 'required');
        }
        $validation->setRule('password', 'Password', 'required');
        $password = $request->getPost('password');
        if ($request->getPost('fcm_id')) {
            $validation->setRule('fcm_id', 'FCM ID', 'trim');
        }
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }

        $login = $ionAuth->login($identity, $password, false);
        if ($login) {
            // Login Success
            if (($request->getPost('fcm_id')) && !empty($request->getPost('fcm_id'))) {
                update_details(['fcm_id' => $request->getPost('fcm_id')], ['phone' => $identity], 'users');
            }
            $data = array();
            array_push($this->user_data, "api_key");
            $data = fetch_details('users', [$identity_column => $identity], $this->user_data)[0];
           

            if(isset($data['image']) && !empty($data['image']))
                {
                    $data['image'] = (file_exists(FCPATH . 'public/backend/assets/profiles/' .  $data['image'])) ? base_url('public/backend/assets/profiles/' .  $data['image']) : ((file_exists(FCPATH .  $data['image'])) ? base_url($data['image']) : ((!file_exists(FCPATH . "public/uploads/users/partners/" .  $data['image'])) ? base_url("public/backend/assets/profiles/default.png") : base_url("public/uploads/users/partners/" .  $data['image'])));
                }
                else{
                    $data['image'] = base_url("public/backend/assets/profiles/default.png");
                }
           



            $token = generate_tokens($identity);

            $token_data['user_id'] = $data['id'];
            $token_data['token'] = $token;
            if (isset($token_data) && !empty($token_data)) {
                insert_details($token_data, 'users_tokens');
            }
            // update_details(['api_key' => $token], ['phone' => $identity], "users");
            // if (isset($data['api_key'])) {
            //     unset($data['api_key']);
            // }
            $response = [
                'error' => false,
                "token" => $token,
                'message' => 'User Logged successfully',
                'data' => $data
            ];
            return $this->response->setJSON($response);
        } else {
            // Login Failed
            if (!exists([$identity_column => $identity], 'users')) {
                $response = [
                    'error' => true,
                    'message' => 'User does not exists !',
                ];
                return $this->response->setJSON($response);
            }
            $response['error'] = true;
            $response['message'] = 'Incorrect password !';
            return $this->response->setJSON($response);
        }
    }
    public function get_statistics()
    {
        /**
         * 
         * last_monthly_sales: 6 // default is 6, pass number to see last that many months sales
         * 
         */
        $db = \Config\Database::connect();
        $last_monthly_sales = (isset($_POST['last_monthly_sales']) && !empty(trim($_POST['last_monthly_sales']))) ? $this->request->getPost("last_monthly_sales") : 6;

        $partner_id = $this->user_details['id'];
        $categories = $db->table('categories c')->select('c.name as name,count(s.id) as total_services')
            ->where(['s.user_id' => $partner_id])
            ->join('services s', 's.category_id=c.id', 'left')
            ->get()->getResultArray();
        if ($categories[0]['name'] == '' && $categories[0]['total_services'] == 0) {
            $this->data['caregories'] = [];
        } else {

            $this->data['caregories'] = $categories;
        }


        // monthly earnings
        $monthly_sales = $db->table('orders')->select('MONTHNAME(date_of_service) as month, SUM(final_total) as total_amount')
            ->where('date_of_service BETWEEN CURDATE() - INTERVAL ' . $last_monthly_sales . ' MONTH AND CURDATE()')
            ->where(['partner_id' => $partner_id, 'date_of_service < ' => date("Y-m-d H:i:s"), "status" => "completed"])
            ->groupBy("MONTH(date_of_service)")
            ->get()->getResultArray();


        $month_wise_sales['monthly_sales'] = $monthly_sales;
        // $month_wise_sales['total_sales'] = array_map('intval', array_column($month_res, 'total_sale'));
        // $month_wise_sales['month_name'] = array_column($month_res, 'month_name');

        $this->data['monthly_earnings'] = $month_wise_sales;

        $total_orders = $db->table('orders o')->select('count(o.id) as `total`')->join('order_services os', 'os.order_id=o.id')
            ->join('users u', 'u.id=o.user_id')
            ->join('users up', 'up.id=o.partner_id')
            ->join('partner_details pd', 'o.partner_id = pd.partner_id')->where(['o.partner_id' => $partner_id])->get()->getResultArray()[0]['total'];

        $total_services = $db->table('services s')->select('count(s.id) as `total`')->where(['user_id' => $partner_id])->get()->getResultArray()[0]['total'];

        $total_balance = $db->table('users u')->select('sum(u.balance) as `total`')->where(['id' => $partner_id])->get()->getResultArray()[0]['total'];

        $total_ratings = $db->table('partner_details p')->select('count(p.ratings) as `total`')->where(['id' => $partner_id])->get()->getResultArray()[0]['total'];
        $number_or_ratings = $db->table('partner_details p')->select('count(p.number_of_ratings) as `total`')->where(['id' => $partner_id])->get()->getResultArray()[0]['total'];
        $income = $db->table('orders o')->select('count(o.id) as `total`')->where(['user_id' => $partner_id])->where("created_at >= DATE(now()) - INTERVAL 7 DAY")->get()->getResultArray()[0]['total'];
        $total_cancel = $db->table('orders o')->select('count(o.id) as `total`')->where(['user_id' => $partner_id])->where(["status" => "cancelled"])->get()->getResultArray()[0]['total'];

        $symbol =   get_currency();
        $this->data['total_services'] = $total_services;
        $this->data['total_orders'] = $total_orders;
        $this->data['total_cancelled_orders'] = $total_cancel;
        $this->data['total_balance'] = $total_balance;
        $this->data['total_ratings'] = $total_ratings;
        $this->data['number_of_ratings'] = $number_or_ratings;
        $this->data['currency'] = $symbol;
        $this->data['income'] = $income;

        if (!empty($this->data)) {

            $response = [
                'error' => false,
                'message' => 'data fetched successfully.',
                'data' => $this->data
            ];
            return $this->response->setJSON($response);
        } else {
            $response = [
                'error' => true,
                'message' => 'No data found',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        // }
    }

    public function verify_user()
    {

        /* Parameters to be passed
            mobile: 9874565478
                or
            email: test@gmail.com */

        $request = \Config\Services::request();
        $config = new \Config\IonAuth();
        $identity_column = $config->identity;
        $validation =  \Config\Services::validation();
        if ($identity_column == 'email') {
            $validation->setRule('email', 'Email', 'valid_email|required');
            $identity = $request->getPost('email');
        } elseif ($identity_column == 'phone') {
            $validation->setRule('mobile', 'Mobile', 'required');
            $identity = $request->getPost('mobile');
        }
        if (!$validation->withRequest($this->request)->run()) {
            $response['error'] = true;
            $response['message'] = $validation->getErrors();
            $response['data'] = array();
            return $this->response->setJSON($response);
        } else {
            if (($request->getPost('mobile')) && exists([$identity_column => $identity], 'users')) {
                $response['error'] = true;
                $response['message'] = 'Phone Number is already registered.Please try again !';
                $response['data'] = array();
                return $this->response->setJSON($response);
            }
            if (($request->getPost('email')) && exists([$identity_column => $identity], 'users')) {
                $response['error'] = true;
                $response['message'] = 'Email is already registered.Please try again !';
                $response['data'] = array();
                print_r(json_encode($this->response));
                return $this->response->setJSON($response);
            }

            $response['error'] = false;
            $response['message'] = 'User does not exist.';
            $response['data'] = array();
            return $this->response->setJSON($response);
        }
    }


    public function get_orders()
    {
        $orders_model = new Orders_model();

        /*
            partner_id:44             
            limit:10           // { default - 25 } optional
            offset:0            // { default - 0 } optional
            sort:               id / name
                                // { default -row_id } optional
            order:DESC/ASC      // { default - ASC } optional
            search:value        // { optional }
            status:awaiting     // { optional }
        */

        $request = \Config\Services::request();
        $validation =  \Config\Services::validation();
        // $validation->setRules(
        //     [
        //         'partner_id' => 'numeric|required',
        //     ]
        // );
        // if (!$validation->withRequest($this->request)->run()) {
        //     $errors = $validation->getErrors();
        //     $response = [
        //         'error' => true,
        //         'message' => $errors,
        //         'data' => []
        //     ];
        //     return $this->response->setJSON($response);
        // }
        $partner_id = $this->user_details['id'];
        // print_r($partner_id);
        $status = !empty($this->request->getPost('status')) ? $this->request->getPost('status') : '';
        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'DESC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        // $filter['status'] = (isset($_POST['status']) && !empty($_POST['status'])) ? $this->request->getPost('status') : "";
        $status = ($this->request->getPost('status') && !empty($this->request->getPost('status'))) ? $this->request->getPost('status') : 0;
        $orders = $orders_model->list(true, $search, $limit, $offset, $sort, $order, ['o.partner_id' => $partner_id, 'o.status' => $status]);
        $partner_id = $this->request->getPost('partner_id');
        $filter = array();
        $filter['user_id'] = $partner_id;
        $filter['status'] = $status;

        $total = $orders['total'];
        unset($orders['total']);

        if (!empty($orders) && $total != 0) {

            $response = [
                'error' => false,
                'message' => 'Orders fetched successfully.',
                'total' => $total,
                'data' => $orders
            ];
            return $this->response->setJSON($response);
        } else {
            $response = [
                'error' => true,
                'message' => 'No data found',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }
    public function register()
    {

        /*
        Post paramrter
        
        username:test_partner
        email:partner@gmail.com 
        mobile:8887775555
        referral_code:MY_CODE     {optional}
        fcm_id:YOUR_FCM_ID        {optional}
        friends_code:45dsrwr      {optional}
        latitude:66.89            {optional}
        longitude:67.8            {optional} 
        */
        if (!isset($_POST)) {
            $response = [
                'error' => true,
                'message' => "Please use Post request",
                'data' => []
            ];
            return $this->response->setJSON($response);
        }

        $ionAuth    = new \IonAuth\Libraries\IonAuth();
        $validation =  \Config\Services::validation();
        $request = \Config\Services::request();
        $config = new \Config\IonAuth();
        $identity_column = $config->identity;
        $tables  = $config->tables;
        $partners_model = new Partners_model();
        $validation->setRules(
            [
                'email' => 'required|valid_email|is_unique[' . $tables['users'] . '.email]',
                'mobile' => 'required|numeric|is_unique[' . $tables['users'] . '.phone]',
                'password' => 'required|min_length[' . $config->minPasswordLength . ']|matches[password_confirm]',
                'password_confirm' => 'required',
                'city_id' => 'required',
                'username' => 'required',
                'fcm_id' => 'permit_empty',
                'referral_code' => 'permit_empty',
                'friends_code' => 'permit_empty',
                'latitude' => 'required',
                'longitude' => 'required',
                'company_name' => 'required',
                'tax_name' => 'required',
                'tax_number' => 'required',
                'advance_booking_days' => 'required',
                'type' => 'required',
                'number_of_members' => 'required',
                'visiting_charges' => 'required',

            ],
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $username = $request->getPost('username');
        $identity = $request->getPost('mobile');
        $email = $request->getPost('email');
        $password = $request->getPost('password');
        $city_id = $request->getPost('city_id');
        $fcm_id = ($request->getPost('fcm_id') && !empty($request->getPost('fcm_id'))) ? $request->getPost('fcm_id') : "";
        $latitude = ($request->getPost('latitude') && !empty($request->getPost('latitude'))) ? $request->getPost('latitude') : "";
        $longitude = ($request->getPost('longitude') && !empty($request->getPost('longitude'))) ? $request->getPost('longitude') : "";
        $path = 'public/backend/assets/profiles/';
        $nationaId_path = "public/uploads/users/national_id/";
        $passport_path = "public/uploads/users/passport/";
        $addressId_path = "public/backend/assets/kyc-details/";

        if (!empty($_FILES['image']) && isset($_FILES['image'])) {
            $file =  $this->request->getFile('image');
            $image_name =  $file->getName();
            if ($file->isValid()) {
                if ($file->move($path, $image_name)) {
                    $image = $path . $image_name;
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Something went wrong please try after some time.',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        }
        if (!empty($_FILES['national_id']) && isset($_FILES['national_id'])) {
            $file =  $this->request->getFile('national_id');
            $nationId_name =  $file->getName();
            if ($file->isValid()) {
                if ($file->move($nationaId_path, $nationId_name)) {
                    $national_id = $nationaId_path . $nationId_name;
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Something went wrong please try after some time.',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        }

        if (!empty($_FILES['address_id']) && isset($_FILES['address_id'])) {
            $file =  $this->request->getFile('address_id');
            $addressId_name =  $file->getName();
            if ($file->isValid()) {
                if ($file->move($addressId_path, $addressId_name)) {
                    $address_id = $addressId_path . $addressId_name;
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Something went wrong please try after some time.',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        }
        if (!empty($_FILES['passport']) && isset($_FILES['passport'])) {
            $file =  $this->request->getFile('passport');
            $passport_name =  $file->getName();
            if ($file->isValid()) {
                if ($file->move($passport_path, $passport_name)) {
                    $passport = $passport_path . $passport_name;
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Something went wrong please try after some time.',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        }
        // --------------------------
        // if (isset($_POST['promo_id']) && !empty($_POST['promo_id'])) {
        //     $promo_id = $_POST['promo_id'];
        // } else {
        //     $promo_id = '';
        // }
        // -------------------------
        $additional_data = [
            'username' => $username,
            'active' => '1',
            'phone' => $identity,
            'latitude' => $latitude,
            'longitude' => $longitude,
            'city' => $city_id,
            'image' => isset($image) ? $image : "",
        ];
        if ($request->getPost('fcm_id')) {
            $additional_data['fcm_id'] = $fcm_id;
        }
        //insert customer in user group table
        $group =  get_group('partners');
        $group_id = [
            'group_id' => $group[0]['group_id']
        ];
        if ($this->request->getPost() && $validation->withRequest($this->request)->run() && $user_id = $ionAuth->register($identity, $password, $email, $additional_data, $group_id)) {
            $data = array();
            $token = generate_tokens($identity);

            //insert token data 
            $token_data['user_id'] = $user_id;
            $token_data['token'] = $token;
            if (isset($token_data) && !empty($token_data)) {
                insert_details($token_data, 'users_tokens');
            }
            update_details(['api_key' => $token], ['username' => $username], "users");
            $data = fetch_details('users', ['id' => $user_id], $this->user_data)[0];
            //remove null value 
            $data = remove_null_values($data);
            $partner_id = $data['id'];
            $bank_name = ($request->getPost('bank_name') && !empty($request->getPost('bank_name'))) ? $request->getPost('bank_name') : "";
            $account_number = ($request->getPost('account_number') && !empty($request->getPost('account_number'))) ? $request->getPost('account_number') : "";
            $account_name = ($request->getPost('account_name') && !empty($request->getPost('account_name'))) ? $request->getPost('account_name') : "";
            $bank_code = ($request->getPost('bank_code') && !empty($request->getPost('bank_code'))) ? $request->getPost('bank_code') : "";
            $swift_code = ($request->getPost('swift_code') && !empty($request->getPost('swift_code'))) ? $request->getPost('swift_code') : "";
            $admin_commission = ($request->getPost('admin_commission') && !empty($request->getPost('admin_commission'))) ? $request->getPost('admin_commission') : "";
            $ratings = ($request->getPost('ratings') && !empty($request->getPost('ratings'))) ? $request->getPost('ratings') : "";
            $number_of_ratings = ($request->getPost('number_of_ratings') && !empty($request->getPost('number_of_ratings'))) ? $request->getPost('number_of_ratings') : "";
            $partner = [
                'partner_id' => $partner_id,
                'company_name' => $request->getPost('company_name'),
                'national_id' => isset($national_id) ? $national_id : "",
                'address_id' => isset($address_id) ? $address_id : "",
                'address' => $request->getPost('address'),
                'passport' => isset($passport) ? $passport : "",
                'tax_name' => $request->getPost('tax_name'),
                'tax_number' => $request->getPost('tax_number'),
                'advance_booking_days' => $request->getPost('advance_booking_days'),
                'type' => $request->getPost('type'),
                'number_of_members' => $request->getPost('number_of_members'),
                'visiting_charges' => $request->getPost('visiting_charges'),
                'bank_name' => $bank_name,
                'account_number' => $account_number,
                'account_name' => $account_name,
                'bank_code' => $bank_code,
                'swift_code' => $swift_code,
                'admin_commission' => $admin_commission,
                'ratings' => $ratings,
                'number_of_ratings' => $number_of_ratings,
                'is_approved' => 2,
            ];


            $partners_model->insert($partner);
            $response = [
                'error' => false,
                'token' => $token,
                'message' => 'User Registered successfully',
                'data' => $data
            ];

            return $this->response->setJSON($response);
        } else {

            $msg = trim(preg_replace('/\r+/', '', preg_replace('/\n+/', '', preg_replace('/\t+/', ' ', strip_tags($ionAuth->errors())))));
            $response = [
                'error' => true,
                'message' => $msg,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function get_partner()
    {

        /*
            partner_id:163            // optional
            limit:10           // { default - 25 } optional
            offset:0            // { default - 0 } optional
            sort:               id / name
                                // { default -row_id } optional
            order:DESC/ASC      // { default - ASC } optional
            search:value        // { optional }
            status:awaiting     // { optional }
        */
        $validation =  \Config\Services::validation();


        if (!isset($_POST)) {
            $response = [
                'error' => true,
                'message' => "Please use Post request",
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $partner_model = new Partners_model();
        $partner_id = $this->user_details['id'];
        $status = !empty($this->request->getPost('status')) ? $this->request->getPost('status') : '';
        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'DESC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $details = $partner_model->list(true, $search, $limit, $offset, $sort, $order, ['pd.partner_id' => $partner_id]);

        $total = $details['total'];
        unset($details['total']);

        if (!empty($details)) {
            $response = [
                'error' => false,
                'message' => 'Partner fetched successfully.',
                'data' => $details
            ];
            return $this->response->setJSON($response);
        } else {
            $response = [
                'error' => true,
                'message' => 'No data found',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function get_settings()
    {
        //     /* 
        //         variable:{variable Name}    {privacy_policy, general_settings} (optional)
        //     */

        $validation =  \Config\Services::validation();
        $request = \Config\Services::request();

        $variable = (isset($_POST['variable']) && !empty($_POST['variable'])) ? $_POST['variable'] : 'all';


        $setting = array();
        $setting = fetch_details('settings', '', 'variable', '', '', '', 'ASC');

        if (isset($variable) && !empty($variable) && in_array(trim($variable), $this->allowed_settings)) {
            $setting_res[$variable] = get_settings($variable, true);
        } else {
            if (isset($this->user_details['id'])) {
                $setting_res['balance'] = fetch_details("users", ["id" => $this->user_details['id']], ['balance']);
                $setting_res['balance'] = (isset($setting_res['balance'][0]['balance'])) ? $setting_res['balance'][0]['balance'] : "0";
            }
            foreach ($setting as $type) {
                $notallowed_settings = ["languages", "email_settings", "country_codes", "api_key_settings", "test", 'payment_gateways_settings'];
                if (!in_array($type['variable'], $notallowed_settings)) {
                    $setting_res[$type['variable']] = get_settings($type['variable'], true);
                }
            }
        }

        if (isset($setting_res) && !empty($setting_res)) {
            $response = [
                'error' => false,
                'message' => "setting recieved Successfully",
                'data' => $setting_res
            ];
        } else {
            $response = [
                'error' => true,
                'message' => "No data found in setting",
                'data' => $setting_res
            ];
        }

        return $this->response->setJSON($response);
    }

    public function get_categories()
    {
        $categories = new Category_model();

        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('slug')) {
            $where['slug'] = $this->request->getPost('slug');
        }
        $where['parent_id'] = 0;

        $data = $categories->list(true, $search, $limit, $offset, $sort, $order, $where);

        if (!empty($data['data'])) {
            return response('Categories fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('categories not found', false);
        }
    }

    public function get_sub_categories()
    {

        $validation =  \Config\Services::validation();
        $validation->setRules(
            [
                'category_id' => 'required',
            ]
        );

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $categories = new Category_model();

        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }
        if ($this->request->getPost('slug')) {
            $where['slug'] = $this->request->getPost('slug');
        }
        if ($this->request->getPost('category_id')) {
            $where['parent_id'] = $this->request->getPost('category_id');
        }
        if (!exists(['parent_id' => $this->request->getPost('category_id')], 'categories')) {
            return response('no sub categories found');
        }
        $data = $categories->list(true, $search, $limit, $offset, $sort, $order, $where);

        if (!empty($data['data'])) {
            return response('Sub Categories fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('Sub categories not found', false);
        }
    }
    public function update_fcm()
    {

        $validation =  \Config\Services::validation();
        $validation->setRules(
            [
                'fcm_id' => 'required',
            ],
            [
                'fcm_id' => [
                    'required' => 'fcm_id is required',
                ]
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }


        $fcm_id = $this->request->getPost('fcm_id');
        if (update_details(['fcm_id' => $fcm_id], ['id' => $this->user_details['id']], 'users')) {
            return response('fcm id updated succesfully', false, ['fcm_id' => $fcm_id]);
        } else {
            return response();
        }
    }

    public function get_taxes()
    {

        $taxes = new Tax_model();

        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->request->getPost('id')) {
            $where['id'] = $this->request->getPost('id');
        }

        $data = $taxes->list(true, $search, $limit, $offset, $sort, $order, $where);

        if (!empty($data['data'])) {
            return response('Taxes fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('Taxes not found', false);
        }
    }

    public function get_services()
    {
        $db      = \Config\Database::connect();
        $Service_model = new Service_model();
        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $category_ids = $this->request->getPost('category_ids');
        $min_budget = $this->request->getPost('min_budget');
        $max_budget = $this->request->getPost('max_budget');
        $rating = $this->request->getPost('rating');


        $where = [];
        $where_in = [];
        $where['user_id'] = $this->user_details['id'];

        $additional_data = [];

        if (isset($category_ids) && !empty($category_ids)) {
            $where_in = explode(",", $category_ids);
        }


        if (($this->request->getPost('latitude') && !empty($this->request->getPost('latitude')) && ($this->request->getPost('longitude') && !empty($this->request->getPost('longitude'))))) {
            $additional_data = [
                'latitude' => $this->request->getPost('latitude'),
                'longitude' => $this->request->getPost('longitude'),
                'city_id' => $this->user_details['city_id'],
            ];
        }
        if (isset($rating) && !empty($rating)) {
            $where['rating >= '] = $rating;
        }
        if (isset($min_budget) && !empty($min_budget) && isset($max_budget) && !empty($max_budget)) {
            $where['s.price >='] = "$min_budget";
            $where['s.price <='] = "$max_budget";
        }

        $data = $Service_model->list(true, $search, $limit, $offset, $sort, $order, $where, $additional_data, 'category_id', $where_in);

        if (isset($data['error'])) {
            return response($data['message']);
        }
        if (!empty($data['data'])) {
            return response('services fetched successfully', false, $data['data'], 200, ['total' => $data['total'], 'min_price' => $data['min_price'], 'max_price' => $data['max_price']]);
        } else {
            return response('services not found', false);
        }
    }

    public function delete_orders()
    {
        // order_id = required

        $validation =  \Config\Services::validation();
        $validation->setRules(
            [
                'order_id' => 'required|numeric',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $order_id = $this->request->getPost('order_id');
        $partner_id = $this->user_details['id'];

        $orders = fetch_details('orders', ['id' => $order_id, 'partner_id' => $partner_id]);
        if (empty($orders)) {
            $response = [
                'error' => true,
                'message' => 'No, Order Found',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }

        $db      = \Config\Database::connect();
        $builder = $db->table('orders')->delete(['id' => $order_id, 'partner_id' => $partner_id]);
        if ($builder) {
            $builder = $db->table('order_services')->delete(['order_id' => $order_id]);
            if ($builder) {
                $response = [
                    'error' => false,
                    'message' => 'Order deleted successfully!',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Order does not exist!',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            $response = [
                'error' => true,
                'message' => 'Order Not Found',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function get_promocodes()
    {
        // partner_id=50  = option param
        $model = new Promo_code_model();
        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'DESC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->user_details['id'] != '') {
            $where['partner_id'] = $this->user_details['id'];
        }

        $data = $model->list(true, $search, $limit, $offset, $sort, $order, $where);

        if (!empty($data['data'])) {
            return response('Promocode fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('Promocode not found', false);
        }
    }

    public function manage_promocode()
    {
        /* Post paramrter
        
        promo_code:WELCOME
        start_date: 2022/05/12 
        end_date: 2022/05/12
        minimum_order_amount:200    
        discount:10        
        discount_type: percentage /amount      
        max_discount_amount: 100          
        minimum_order_amount:500   
        repeat_usage  : 1/ 0  { optional }   
        no_of_repeat_usage  : 0  { optional }   
        status  : 1 
        no_of_users : 5
        image : url {optional}
        message : required
        */
        $db      = \Config\Database::connect();
        $this->validation =  \Config\Services::validation();

        $this->validation->setRules([
            'promo_code' => 'required',
            // 'partner_id' => 'required',
            'start_date' => 'required',
            'end_date' => 'required',
            'minimum_order_amount' => 'required|numeric',
            'discount' => 'required|numeric',
            'discount_type' => 'required',
            'max_discount_amount' => 'required|numeric',
            'status' => 'required',
            'message' => 'required',
        ]);
        $partner_id = $this->user_details['id'];
        $path = './public/uploads/promocodes/';
        if (isset($_POST['promo_id']) && !empty($_POST['promo_id'])) {
            $where['id'] = $_POST['promo_id'];
            $old_image = fetch_details('promo_codes', $where,'image');
        }
        $image = "";
        if (!empty($_FILES['image']) && isset($_FILES['image'])) {
            $file =  $this->request->getFile('image');
            if ($file->isValid()) {
                if ($file->move($path)) {
                    if (isset($_POST['promo_id']) && !empty($_POST['promo_id'])) {
                        if (file_exists($old_image) && !empty($old_image)) {
                            // unlink($old_image);
                        }
                    }
                    $image = 'public/uploads/promocodes/' . $file->getName();
                }
            } else {
                $image = $old_image;
            }
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        } else {
            $promocode_model = new Promo_code_model();
            $status = ($this->request->getPost('status') && !empty($this->request->getPost('status'))) ? $this->request->getPost('status') : 1;
            $users = ($this->request->getPost('no_of_users') && !empty($this->request->getPost('no_of_users'))) ? $this->request->getPost('no_of_users') : 1;
            $repeat_usage = ($this->request->getPost('repeat_usage') && !empty($this->request->getPost('repeat_usage'))) ? $this->request->getPost('repeat_usage') : 0;
            $no_of_repeat_usage = ($this->request->getPost('no_of_repeat_usage') && !empty($this->request->getPost('no_of_repeat_usage'))) ? $this->request->getPost('no_of_repeat_usage') : 0;

            if (isset($_POST['promo_id']) && !empty($_POST['promo_id'])) {
                $promo_id = $_POST['promo_id'];
            } else {
                $promo_id = '';
            }
            $promocode = array(
                'id' => $promo_id,
                'partner_id' => $partner_id,
                'promo_code' => $this->request->getVar('promo_code'),
                'message' => $this->request->getVar('message'),
                'start_date' => $this->request->getVar('start_date'),
                'end_date' => $this->request->getVar('end_date'),
                'no_of_users' => $users,
                'minimum_order_amount' => $this->request->getVar('minimum_order_amount'),
                'max_discount_amount' => $this->request->getVar('max_discount_amount'),
                'discount' => $this->request->getVar('discount'),
                'discount_type' => $this->request->getVar('discount_type'),
                'repeat_usage' => $repeat_usage,
                'no_of_repeat_usage' => $no_of_repeat_usage,
                'image' => $image,
                'status' => $status,
            );
            $promocode_model->save($promocode);
            if ($id = $db->insertID()) {
                $data = fetch_details('promo_codes', ['id' => $id], ['promo_code', 'start_date', 'end_date', 'minimum_order_amount', 'discount', 'discount_type', 'max_discount_amount', 'repeat_usage', 'no_of_repeat_usage', 'no_of_users', 'message', 'status', 'image']);

                $response = [
                    'error' => false,
                    'message' => 'Promocode saved successfully',
                    'data' => $data
                ];
            } else {
                $data = fetch_details('promo_codes', ['id' => $promo_id], ['promo_code', 'start_date', 'end_date', 'minimum_order_amount', 'discount', 'discount_type', 'max_discount_amount', 'repeat_usage', 'no_of_repeat_usage', 'no_of_users', 'message', 'status', 'image']);

                $response = [
                    'error' => false,
                    'message' => 'Promocode updated successfully',
                    'data' => $data
                ];
            }
            return $this->response->setJSON($response);
        }
    }

    public function delete_promocode()
    {

        $validation =  \Config\Services::validation();
        $validation->setRules(
            [
                'promo_id' => 'required|numeric',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $promo_id = $this->request->getPost('promo_id');
        $is_exist =  exists(['id' => $promo_id], 'promo_codes');
        if (!$is_exist) {
            $response = [
                'error' => true,
                'message' => 'Promo code does not exist!',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $db      = \Config\Database::connect();
        $builder = $db->table('promo_codes')->delete(['id' => $promo_id]);
        if ($builder) {
            $response = [
                'error' => false,
                'message' => 'Promocode deleted successfully!',
                'data' => []
            ];
            return $this->response->setJSON($response);
        } else {
            $response = [
                'error' => true,
                'message' => 'Promocode does not exist!',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function send_withdrawal_request()
    {
        /* Post paramrter
        user_id:50
        payment_address: acc no,banak  
        amount: 500
        user_type : partner / customer,
        remarks : text { optional}
        status  : 0/1/2 default 0
        */
        $this->validation =  \Config\Services::validation();

        $this->validation->setRules([
            'payment_address' => 'required',
            'amount' => 'required|numeric',
            'user_type' => 'required',
        ]);
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        } else {
            $model = new Payment_request_model();
            if (isset($_POST['id']) && !empty($_POST['id'])) {
                $request_id = $_POST['id'];
            } else {
                $request_id = '';
            }
            $user_id = ($this->request->getVar('user_id') != '') ? $this->request->getVar('user_id') : $this->user_details['id'];
            $amount = $this->request->getVar('amount');
            $payment_request = array(
                'id' => $request_id,
                'user_id' => $user_id,
                'user_type' => $this->request->getVar('user_type'),
                'payment_address' => $this->request->getVar('payment_address'),
                'amount' => $amount,
                'remarks' => $this->request->getVar('remarks'),
                'status' => 0,
            );
            if ($model->save($payment_request)) {
                $current_balance =  fetch_details('users', ['id' => $user_id], ['balance']);
                if ($current_balance[0]['balance'] > $amount) {
                    update_balance($this->request->getVar('amount'), $user_id, 'deduct');
                    $balance = fetch_details("users", ["id" => $this->user_details['id']], ['balance']);

                    $response = [
                        'error' => false,
                        'message' => 'payment request sent!',
                        'balance' => $balance[0]['balance'],
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                } else {
                    $response = [
                        'error' => true,
                        'message' => 'Insufficient Balance!',
                        'data' => []
                    ];
                    return $this->response->setJSON($response);
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => 'payment request failed!',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        }
    }

    public function get_withdrawal_request()
    {
        // user_id = 50  = option param
        $model = new Payment_request_model();
        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'DESC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->user_details['id'] !== '') {
            $where['user_id'] = $this->user_details['id'];
        }

        $data = $model->list(true, $search, $limit, $offset, $sort, $order, $where);

        if (!empty($data['data'])) {
            return response('Payment Request fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
        } else {
            return response('Payment Request not found', false);
        }
    }
    public function delete_withdrawal_request()
    {
        $validation =  \Config\Services::validation();
        $validation->setRules(
            [
                'id' => 'required|numeric',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $id = $this->request->getPost('id');
        $is_exist = fetch_details('payment_request', ['id' => $id, 'user_id' => $this->user_details['id']]);

        if (!empty($is_exist)) {
            $db      = \Config\Database::connect();

            $builder = $db->table('payment_request')->delete(['id' => $id]);
            $response = [
                'error' => false,
                'message' => 'Payment request deleted successfully!',
                'data' => []
            ];
            return $this->response->setJSON($response);
        } else {
            $response = [
                'error' => true,
                'message' => 'Payment request does not exist!',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function manage_service()
    {
        /* 
                service_id => "1" /optional
                'title' => 'required',
                'tags' => 'required',
                'description' => 'required',
                'price' => 'required|numeric|greater_than[0]',
                'duration' => 'required|numeric|greater_than[5]',
                'max_qty' => 'required|numeric|greater_than[0]',
                'tags' => 'required',
                'members' => 'required|numeric|greater_than_equal_to[1]',
                'categories'=> 'required',
                

        */
        $tax = get_settings('system_tax_settings', true);



        $this->validation =  \Config\Services::validation();
        $this->validation->setRules(
            [
                'title' => 'required',
                'description' => 'required',
                'price' => 'required|numeric|greater_than[0]',
                'duration' => 'required|numeric|greater_than[5]',
                'max_qty' => 'required|numeric|greater_than[0]',
                'tags' => 'required',
                'members' => 'required|numeric|greater_than_equal_to[1]',
                'categories' => 'required',
                // 'cancelable_till' => 'required',
                'discounted_price' => "permit_empty|numeric",
                'is_cancelable' => 'numeric'
            ],
        );
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        } else {
            if (isset($_POST['tags']) && !empty($_POST['tags'])) {
                $base_tags = $this->request->getPost('tags');
                $s_t = $base_tags;
                $val = explode(',', str_replace(']', '', str_replace('[', '', $s_t[0])));
                $tags = [];
                foreach ($val as $s) {
                    $tags[] = json_decode($s, true);
                }
            } else {
                $response = [
                    'error' => true,
                    'message' => "Tags required!",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
            $title = $this->removeScript($this->request->getPost('title'));
            $description = $this->removeScript($this->request->getPost('description'));
            $path = "./public/uploads/services/";
            if (isset($_POST['service_id']) && !empty($_POST['service_id'])) {
                $service_id = $_POST['service_id'];
                $old_icon = fetch_details('services', ['id' => $service_id], ['image'])[0]['image'];
            } else {
                $service_id = "";
                $old_icon = "";
            }
            $image_name = "";
            if (!empty($_FILES['image']) && isset($_FILES['image'])) {
                $file =  $this->request->getFile('image');
                if ($file->isValid()) {
                    if ($file->move($path)) {
                        if (file_exists($old_icon) && !empty($old_icon)) {
                            unlink($old_icon);
                        }
                        $image_name = 'public/uploads/services/' . $file->getName();
                    }
                } else {
                    $image_name = $old_icon;
                }
            }

            if (isset($_POST['sub_category']) && !empty($_POST['sub_category'])) {
                $category_id = $_POST['sub_category'];
            } else {
                $category_id = $_POST['categories'];
            }
            $discounted_price = $this->request->getPost('discounted_price');
            $price = $this->request->getPost('price');
            if ($discounted_price > $price) {
                $response = [
                    'error' => true,
                    'message' => "discounted price can not be higher than the price",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
            if ($discounted_price == $price) {
                $response = [
                    'error' => true,
                    'message' => "discounted price can not equal to the price",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
            $user_id = $this->user_details['id'];

            $service = [
                'id' => $service_id,
                'user_id' => $user_id,
                'category_id' => $category_id,
                'tax_type' => ($this->request->getPost('tax_type') != '') ? $this->request->getPost('tax_type') : 'GST',
                'tax_id' => ($this->request->getVar('tax_id') != '') ? $this->request->getVar('tax_id') : '0',
                'tax' => ($this->request->getPost('tax') != '') ? $this->request->getPost('tax') : '0',
                'title' => $title,
                'description' => $description,
                'slug' => '',
                'tags' =>  implode(',', $tags),
                'price' => $price,
                'discounted_price' => ($discounted_price != '') ? $discounted_price : '00',
                'image' => $image_name,
                'number_of_members_required' => $this->request->getVar('members'),
                'duration' => $this->request->getVar('duration'),
                'rating' => 1,
                'on_site_allowed' => 10,
                'number_of_ratings' => 10,
                'on_site_allowed' => ($this->request->getPost('on_site') == "on") ? 1 : 0,
                'is_pay_later_allowed' => ($this->request->getPost('pay_later') == "on") ? 1 : 0,
                'is_cancelable' => ($this->request->getPost('is_cancelable') == 1) ? 1 : 0,
                'cancelable_till' => ($this->request->getVar('cancelable_till') != "") ? $this->request->getVar('cancelable_till') : '00',
                'max_quantity_allowed' => $this->request->getPost('max_qty')
            ];
            // print_r($service);
            $service_model = new Service_model;
            $db      = \Config\Database::connect();
            if ($service_model->save($service)) {
                if ($id = $db->insertID()) {
                    $data = fetch_details('services', ['id' => $id], ['id', 'title', 'tags', 'description', 'price', 'duration', 'max_quantity_allowed', 'number_of_members_required', 'category_id', 'cancelable_till', 'is_pay_later_allowed', 'is_cancelable', 'discounted_price', 'tax_type', 'image']);

                    $response = [
                        'error' => false,
                        'message' => "Service saved successfully!",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => $data
                    ];
                } else {
                    $data = fetch_details('services', ['id' => $service_id], ['id', 'title', 'tags', 'description', 'price', 'duration', 'max_quantity_allowed', 'number_of_members_required', 'category_id', 'cancelable_till', 'is_pay_later_allowed', 'is_cancelable', 'discounted_price', 'tax_type', 'image']);

                    $response = [
                        'error' => false,
                        'message' => "Service updated successfully!",
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'data' => $data
                    ];
                }
                // $response = [
                //     'error' => false,
                //     'message' => "Service saved successfully!",
                //     'csrfName' => csrf_token(),
                //     'csrfHash' => csrf_hash(),
                //     'data' => $data
                // ];
                return $this->response->setJSON($response);
            } else {

                // if (!empty($data['data'])) {
                //     return response('services fetched successfully', false, $data['data'], 200, ['total' => $data['total']]);
                // } 
                $response = [
                    'error' => true,
                    'message' => "Service can not be Saved!",
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        }
    }

    public function delete_service()
    {

        // service_id = required

        $validation =  \Config\Services::validation();
        $validation->setRules(
            [
                'service_id' => 'required|numeric',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $service_id = $this->request->getPost('service_id');
        $exist_service = fetch_details('services', ['id' => $service_id, 'user_id' => $this->user_details['id']], ['id']);
        if (!empty($exist_service)) {
            $db      = \Config\Database::connect();
            $builder = $db->table('services')->delete(['id' => $service_id, 'user_id' => $this->user_details['id']]);
            if ($builder) {
                $response = [
                    'error' => false,
                    'message' => 'Service deleted successfully!',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Service does not exist!',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            $response = [
                'error' => true,
                'message' => 'Service does not exist!',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }

    public function get_transactions()
    {
        /*
            partner_id = required
            limit:10            {optional}
            offset:0            {optional}
            sort:id             {optional}
            order:asc           {optional}
        */

        $transaction_model = new Transaction_model;

        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        $where = [];

        if ($this->user_details['id'] != '') {
            $where['partner_id'] = $this->user_details['id'];
        }

        $data = $transaction_model->list_transactions(true, $search, $limit, $offset, $sort, $order, $where);

        return response('Transactions received successfully.', false, $data, 200);
    }

    public function update_service_status()
    {
        $validation =  \Config\Services::validation();
        $validation->setRules(
            [
                'service_id' => 'required|numeric',
                'status' => 'required',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $service_id = $this->request->getPost('service_id');
        $status = $this->request->getPost('status');
        $exist_service = fetch_details('services', ['id' => $service_id, 'user_id' => $this->user_details['id']], ['id']);

        if (!empty($exist_service)) {
            $res = update_details(['status' => $status], ['id' => $service_id, 'user_id' => $this->user_details['id']], 'services');
            if ($res) {
                $response = [
                    'error' => false,
                    'message' => 'Service status updated successfully!',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            } else {
                $response = [
                    'error' => true,
                    'message' => 'Service status cant be changed!',
                    'data' => []
                ];
                return $this->response->setJSON($response);
            }
        } else {
            $response = [
                'error' => true,
                'message' => 'Service status cant be changed!',
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
    }
    public function update_order_status()
    {
        /*
            order_id:42
            status:rescheduled
            date:2022-11-28 {optional} only enter when update status to rescheduled
            time:11:00:00 {optional} only enter when update status to rescheduled
            customer_id:1
        */

        $validation =  \Config\Services::validation();
        $validation->setRules(
            [
                'order_id' => 'required|numeric',
                'customer_id' => 'required|numeric',
                'status' => 'required',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $order_id = $this->request->getPost('order_id');
        $status = $this->request->getPost('status');
        $customer_id = $this->request->getPost('customer_id');
        $date = $this->request->getPost('date');
        $selected_time = $this->request->getPost('time');
        if ($status == "rescheduled") {
            $res =  validate_status($order_id, $status, $date, $selected_time);
        } else {
            $res =  validate_status($order_id, $status);
        }
        if ($res['error']) {
            $response['error'] = true;
            $response['message'] = $res['message'];
            $response['data'] = array();
            return $this->response->setJSON($response);
        }
        // if ($status == "cancelled") {
        //     $transaction = fetch_details('transactions', ['order_id' => $order_id, 'transaction_type' => 'transaction'], ['amount', 'txn_id', 'type', 'currency_code', 'status']);
        //     if (isset($transaction) && !empty($transaction)) {
        //         $type = $transaction[0]['type'];
        //         $currency = $transaction[0]['currency_code'];
        //         $txn_id = $transaction[0]['txn_id'];
        //         $amount = $transaction[0]['amount'];
        //         if ($type == 'flutterwave' && $transaction[0]['status'] == "successfull") {
        //             $flutterwave = new Flutterwave();
        //             $payment = $flutterwave->refund_payment($txn_id, $amount);
        //             if (isset($payment['status']) && $payment['status'] == 'success') {
        //                 $data = [
        //                     'transaction_type' => 'refund',
        //                     'order_id' => $order_id,
        //                     'user_id' => $customer_id,
        //                     'type' => 'flutterwave',
        //                     'txn_id' => $payment['id']
        //                 ];
        //                 $success =  insert_details($data, 'transactions');
        //                 $response['error'] = false;
        //                 $response['message'] = "Payment Refund Successfully";
        //                 if ($success) {
        //                     update_details(['status' => $status], ['id' => $order_id], 'orders');
        //                     $response = [
        //                         'error' => false,
        //                         'message' => "Order cancelled Successfully!",
        //                     ];
        //                     return $this->response->setJSON($response);
        //                 }
        //             } else {
        //                 $message = json_decode($payment, true);
        //                 $response['error'] = true;
        //                 $response['message'] = $message['message'];
        //             }
        //         }
        //         if ($type == "stripe" && $transaction[0]['status'] == 'succeeded') {
        //             $stripe = new Stripe();
        //             $payment = $stripe->refund($txn_id, $amount);
        //             if (isset($payment['status']) && $payment['status'] == "succeeded") {
        //                 $amount = intval($payment['amount']) / 100;
        //                 $data = [
        //                     'transaction_type' => $payment['object'],
        //                     'order_id' => $order_id,
        //                     'user_id' => $customer_id,
        //                     'type' => 'stripe',
        //                     'txn_id' => $payment['payment_intent'],
        //                     'amount' => $amount,
        //                     'currency_code' => $currency,
        //                     'status' => $payment['status']

        //                 ];
        //                 $success = insert_details($data, 'transactions');
        //                 $response = [
        //                     'error' => false,
        //                     'message' => "Payment Refund Successfully",
        //                 ];
        //                 if ($success) {
        //                     update_details(['status' => $status], ['id' => $order_id], 'orders');
        //                     $response = [
        //                         'error' => false,
        //                         'message' => "Order cancelled Successfully!",
        //                     ];
        //                     return $this->response->setJSON($response);
        //                 }

        //                 return $this->response->setJSON($response);
        //             } else {
        //                 $res = json_decode($payment['body']);
        //                 $msg = $res->error->message;
        //                 $response = [
        //                     'error' => true,
        //                     'message' => $msg,
        //                 ];
        //                 return $this->response->setJSON($response);
        //             }
        //         }
        //         if ($type == "razorpay" && $transaction[0]['status'] == "captured") {
        //             $razorpay = new Razorpay();
        //             $payment = $razorpay->refund_payment($txn_id, $amount);
        //             if (isset($payment['status']) && $payment['status'] == "processed") {
        //                 $amount = intval($payment['amount']) / 100;
        //                 $data = [
        //                     'transaction_type' => $payment['entity'],
        //                     'order_id' => $order_id,
        //                     'user_id' => $customer_id,
        //                     'type' => 'razorpay',
        //                     'txn_id' => $payment['payment_id'],
        //                     'amount' => $amount,
        //                     'currency_code' => $currency,
        //                     'status' => $payment['status']

        //                 ];
        //                 $success = insert_details($data, 'transactions');
        //                 if ($success) {
        //                     update_details(['status' => $status], ['id' => $order_id], 'orders');
        //                     $response = [
        //                         'error' => false,
        //                         'message' => "Order cancelle    d Successfully!",
        //                     ];
        //                     return $this->response->setJSON($response);
        //                 } else {
        //                     $response = [
        //                         'error' => false,
        //                         'message' => "order can not be cancelled",
        //                     ];
        //                     return $this->response->setJSON($response);
        //                 }
        //             } else {
        //                 $res = json_decode($payment['body'], true);
        //                 $msg = $res['error']['description'];
        //                 $response = [
        //                     'error' => true,
        //                     'message' => $msg,
        //                 ];
        //                 return $this->response->setJSON($response);
        //             }
        //         }
        //         if ($type == "paystack" && $transaction[0]['status'] == "success") {
        //             $paystack = new Paystack();
        //             $payment = $paystack->refund($txn_id, $amount);
        //             $message = json_decode($payment, true);
        //             if (isset($payment['status']) && $payment['status'] == "true") {
        //                 update_details(['status' => $status], ['id' => $order_id], 'orders');
        //                 $amount = intval($payment['amount']) / 100;
        //                 $data = [
        //                     'transaction_type' => $payment['entity'],
        //                     'order_id' => $order_id,
        //                     'user_id' => $customer_id,
        //                     'type' => 'paystack',
        //                     'txn_id' => $payment['payment_id'],
        //                     'amount' => $amount,
        //                     'currency_code' => $currency,
        //                     'status' => $payment['status']

        //                 ];
        //                 $success = insert_details($data, 'transactions');
        //                 if ($success) {
        //                     $response = [
        //                         'error' => false,
        //                         'message' => "Order cancelled Successfully!",
        //                     ];
        //                     return $this->response->setJSON($response);
        //                 } else {
        //                     $response = [
        //                         'error' => false,
        //                         'csrfName' => csrf_token(),
        //                         'csrfHash' => csrf_hash(),
        //                         'message' => "order can not be cancelled",
        //                     ];
        //                     return $this->response->setJSON($response);
        //                 }
        //             } else {
        //                 $res = json_decode($payment, true);
        //                 $response = [
        //                     'error' => true,
        //                     'csrfName' => csrf_token(),
        //                     'csrfHash' => csrf_hash(),
        //                     'message' => $res['message'],
        //                 ];
        //                 return $this->response->setJSON($response);
        //             }
        //         }
        //     }
        // }
        if ($status == "rescheduled") {

            $user_no = fetch_details('users', ['id' => $customer_id], 'phone')[0]['phone'];
            $response = [
                'error' => false,
                'message' => "Order rescheduled successfully!",
                'contact' => "You can call on '.$user_no.' number to reschedule",
            ];
            return $this->response->setJSON($response);
        }
        if ($status == "awaiting") {
            $response = [
                'error' => false,
                'message' => "Order is in Awaiting!",
            ];
            return $this->response->setJSON($response);
        }
        if ($status == "confirmed") {
            $response = [
                'error' => false,
                'message' => "Order is Confirmed!",
            ];
            return $this->response->setJSON($response);
        }
        if ($status == "cancelled") {
            $response = [
                'error' => false,
                'message' => "Order is cancelled!",
            ];
            return $this->response->setJSON($response);
        }
        if ($status == "completed") {
            $response = [
                'error' => false,
                'message' => "Order Completed successfully!",
            ];
            return $this->response->setJSON($response);
        }

        //custom notification message
        if ($status == 'awaiting') {
            $type = ['type' => "customer_order_awaiting"];
        } elseif ($status == 'confirmed') {
            $type = ['type' => "customer_order_confirmed"];
        } elseif ($status == 'rescheduled') {
            $type = ['type' => "customer_order_rescheduled"];
        } elseif ($status == 'cancelled') {
            $type = ['type' => "customer_order_cancelled"];
        } elseif ($status == 'completed') {
            $type = ['type' => "customer_order_completed"];
        }
        $custom_notification = fetch_details('notifications', $type);
        $app_name = isset($settings['company_title']) && !empty($settings['company_title']) ? $settings['company_title'] : '';
        $user_res = fetch_details('users', ['id' => $customer_id], 'username,fcm_id');
        $customer_msg = (!empty($custom_notification)) ? $custom_notification[0]['message'] :  'Hello Dear ' . $user_res[0]['username'] . ' order status updated to ' . $status . ' for your order ID #' . $order_id . ' please take note of it! Thank you for shopping with us. Regards ' . $app_name . '';
        $fcm_ids = array();

        if (!empty($user_res[0]['fcm_id'])) {
            $fcmMsg = array(
                'title' => (!empty($custom_notification)) ? $custom_notification[0]['title'] : "Order status updated",
                'body' => $customer_msg,
                'type' => "order"
            );
            $fcm_ids[0][] = $user_res[0]['fcm_id'];
            send_notification($fcmMsg, $fcm_ids);
        }
    }

    public function get_service_ratings()
    {
        $db      = \Config\Database::connect();
        $this->validation =  \Config\Services::validation();
        $errors = $this->validation->getErrors();
        $response = [
            'error' => true,
            'message' => $errors,
            'data' => []
        ];
        $partner_id = $this->user_details['id'];
        // print_r($partner_id);
        $limit = (isset($_POST['limit']) && !empty($_POST['limit'])) ? $_POST['limit'] : 10;
        $offset = (isset($_POST['offset']) && !empty($_POST['offset'])) ? $_POST['offset'] : 0;
        $sort = (isset($_POST['sort']) && !empty($_POST['sort'])) ? $_POST['sort'] : 'id';
        $order = (isset($_POST['order']) && !empty($_POST['order'])) ? $_POST['order'] : 'ASC';
        $search = (isset($_POST['search']) && !empty($_POST['search'])) ? $_POST['search'] : '';
        $Service_id = ($this->request->getPost('service_id') != '') ? $this->request->getPost('service_id') : '';
        // $partner_id = ($this->request->getPost('partner_id') != '') ? $this->request->getPost('partner_id') : '';

        $where = "s.user_id={$partner_id} OR sr.service_id={$Service_id}";

        $ratings = new Service_ratings_model();


        if ($partner_id != '') {

            $data = $ratings->ratings_list(true, $search, $limit, $offset, $sort, $order, $where);
        } else {
            $data = $ratings->ratings_list(true, $search, $limit, $offset, $sort, $order);
        }
        $rate_data = get_ratings($partner_id);

        $average_rating = $db->table('services s')
            ->select(' 
                (SUM(sr.rating) / count(sr.rating)) as average_rating
                ')
            ->join('services_ratings sr', 'sr.service_id = s.id')
            ->where('s.user_id', $partner_id)
            ->get()->getResultArray();
        // print_r($average_rating);

        $ratingData = array();
        $rows = array();
        $tempRow = array();
        foreach ($average_rating as $row) {
            $tempRow['average_rating'] = (isset($row['average_rating']) && $row['average_rating'] != "") ? $row['average_rating'] : 0;
        }
        foreach ($rate_data as $row) {
            $tempRow['total_ratings'] = (isset($row['total_ratings']) && $row['total_ratings'] != "") ? $row['total_ratings'] : 0;
            $tempRow['rating_5'] = (isset($row['rating_5']) && $row['rating_5'] != "") ? $row['rating_5'] : 0;
            $tempRow['rating_4'] = (isset($row['rating_4']) && $row['rating_4'] != "") ? $row['rating_4'] : 0;
            $tempRow['rating_3'] = (isset($row['rating_3']) && $row['rating_3'] != "") ? $row['rating_3'] : 0;
            $tempRow['rating_2'] = (isset($row['rating_2']) && $row['rating_2'] != "") ? $row['rating_2'] : 0;
            $tempRow['rating_1'] = (isset($row['rating_1']) && $row['rating_1'] != "") ? $row['rating_1'] : 0;
            $rows[] = $tempRow;
            // print_r($row['total_ratings']);
            // (isset($settings['company_title']) && $settings['company_title'] != "") ? $settings['company_title'] : "eDemand";
        }
        $ratingData = $rows;
        // print_r($rate_data);
        $response = [
            'error' => false,
            'message' => "Data Retrieved successfully!",
            'csrfName' => csrf_token(),
            'csrfHash' => csrf_hash(),
            'ratings' => $ratingData,
            'data' => remove_null_values($data['data']),
            'total' => $data['total']
        ];
        return $this->response->setJSON($response);

        // return response('Data Retrieved successfully', false, remove_null_values($data['data']), 200, ['total' => $data['total']]);
    }

    public function get_notifications()
    {
        /*
            id:10                   {optional}
            limit:10                {optional}
            offset:0                {optional}
            sort:id                 {optional}
            order:asc               {optional}
            search:test             {optional}
        */
        $partner_id = $this->user_details['id'];
        $limit = !empty($this->request->getPost('limit')) ?  $this->request->getPost('limit') : 10;
        $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
        $sort = ($this->request->getPost('sort') && !empty($this->request->getPost('soft'))) ? $this->request->getPost('sort') : 'id';
        $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'DESC';
        $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
        // $partner_id = $this->request->getPost('id');

        $where = $additional_data = [];

        if ($this->request->getPost('id') && !empty($this->request->getPost('id'))) {
            $where['id'] = $this->request->getPost('id');
        }

        $where['user_id'] = $partner_id;

        $notifications = new Notification_model();

        $get_notifications = $notifications->list(true, $search, $limit, $offset, $sort, $order, $where);
        foreach ($get_notifications['data'] as $key => $notifcation) {
            $dateTime = new DateTime($notifcation['date_sent']);
            $date = $dateTime->format('Y-m-d');
            $time = $dateTime->format('H:i');
            if ($date == date('Y-m-d')) {
                $start = strtotime($time);
                $end = time();
                $duration = $start - $end;
                $duration = date('H', $duration) . ' hours ago';
            } else {
                $now = time(); // or your date as well
                $date = strtotime($date);
                $datediff = $now - $date;
                $duration = round($datediff / (60 * 60 * 24)) . ' days ago';
            }
            $get_notifications['data'][$key]['duration'] = $duration;
        }
        if (!empty($id)) {
            return $get_notifications['data'];
        }
        if (!empty($get_notifications['data'])) {
            return response('Notifications fetched successfully', false, remove_null_values($get_notifications['data']), 200, ['total' => $get_notifications['total']]);
        } else {
            return response('Notification Not Found');
        }
    }

    // available slots api
    public function get_available_slots()
    {
        //     /*   
        //         date : 2022-11-01
        //     */

        $validation =  \Config\Services::validation();
        $validation->setRules(
            [

                'date' => 'required|valid_date[Y-m-d]',
            ]
        );
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response = [
                'error' => true,
                'message' => $errors,
                'data' => []
            ];
            return $this->response->setJSON($response);
        }
        $days = [
            'Mon' => 'monday',
            'Tue' => 'tuesday',
            'Wed' => 'wednesday',
            'Thu' => 'thursday',
            'Fri' => 'friday',
            'Sat' => 'saturday',
            'Sun' => 'sunday'
        ];
        // $partner_id = $this->request->getPost('partner_id');
        $partner_id = $this->user_details['id'];
        $date = $this->request->getPost('date');
        $time = $this->request->getPost('date');
        $date = new DateTime($date);
        $date = $date->format('Y-m-d');
        $day =  date('D', strtotime($date));
        $whole_day = $days[$day];


        $partner_data = fetch_details('partner_details', ['partner_id' => $partner_id], ['advance_booking_days']);
        $time_slots = get_available_slots($partner_id, $date);
        // print_R($time_slots);
        $available_slots = $busy_slots = $time_slots['all_slots'] = [];

        if (isset($time_slots['available_slots']) && !empty($time_slots['available_slots'])) {
            $available_slots = array_map(function ($time_slot) {
                return ["time" => $time_slot, "is_available" => 1];
            }, $time_slots['available_slots']);
        }

        if (isset($time_slots['busy_slots']) && !empty($time_slots['busy_slots'])) {
            $busy_slots = array_map(function ($time_slot) {
                return ["time" => $time_slot, "is_available" => 0];
            }, $time_slots['busy_slots']);
        }
        $time_slots['all_slots'] = array_merge($available_slots, $busy_slots);
        array_sort_by_multiple_keys($time_slots['all_slots'], ["time" => SORT_ASC]);
        $partner_timing = fetch_details('partner_timings', ['partner_id' => $partner_id, "day" => $whole_day]);

        if (!empty($partner_data) && $partner_data[0]['advance_booking_days'] > 0) {
            $allowed_advanced_booking_days = $partner_data[0]['advance_booking_days'];
            $current_date = new DateTime();
            $max_available_date =  $current_date->modify("+ $allowed_advanced_booking_days day")->format('Y-m-d');

            if ($date > $max_available_date) {
                $response = [
                    'error' => true,
                    'message' => "You'can not choose date beyond available booking days which is + $allowed_advanced_booking_days days",
                    'data' => []
                ];
                return $this->response->setJSON(remove_null_values($response));
            }
        } else if (!empty($partner_data) && $partner_data[0]['advance_booking_days'] == 0) {
            $current_date = new DateTime();
            if ($date > $current_date->format('Y-m-d')) {
                $response = [
                    'error' => true,
                    'message' => "Advanced Booking for this partner is not available",
                    'data' => []
                ];
                return $this->response->setJSON(remove_null_values($response));
            }
        } else {
            $response = [
                'error' => true,
                'message' => "No Partner Found",
                'data' => []
            ];
            return $this->response->setJSON(remove_null_values($response));
        }

        // if (empty($partner_timing)) {
        //     $response = [
        //         'error' => true,
        //         'message' => "Partner Is closed on this day",
        //         'data' => []
        //     ];
        //     return $this->response->setJSON(remove_null_values($response));
        // }

        // if ($partner_timing[0]['is_open'] == 0) {
        //     $response = [
        //         'error' => true,
        //         'message' => "Partner Is closed on this day",
        //         'data' => []
        //     ];
        //     return $this->response->setJSON(remove_null_values($response));
        // }
        // if ($time < $partner_timing[0]['opening_time']) {
        //     $response = [
        //         'error' => true,
        //         'message' => "Partner is not available at this time",
        //         'data' => []
        //     ];
        //     return $this->response->setJSON(remove_null_values($response));
        // }
        // if ($time >= $partner_timing[0]['closing_time']) {
        //     $response = [
        //         'error' => true,
        //         'message' => "please Choose different time , Partner will be closed at this time",
        //         'data' => []
        //     ];
        //     return $this->response->setJSON(remove_null_values($response));
        // }

        if (!empty($time_slots)) {
            $response = [
                'error' => $time_slots['error'],
                'message' => ($time_slots['error'] == false) ? 'Found Time slots' : 'No slot available for this date',
                'data' => [
                    'all_slots' => (!empty($time_slots) && $time_slots['error'] == false) ? $time_slots['all_slots'] : [],
                    // 'available_slots' => (!empty($time_slots) && $time_slots['error'] == false) ? $time_slots['available_slots'] : [],
                    // 'busy_slots' => (!empty($time_slots) && $time_slots['error'] == false) ? $time_slots['busy_slots'] : []
                ]
            ];
            return $this->response->setJSON(remove_null_values($response));
        } else {
            $response = [
                'error' => true,
                'message' => 'No slot is available on this date!',
                'data' => []
            ];
            return $this->response->setJSON(remove_null_values($response));
        }
    }
    public function delete_provider_account()
    {
        $user_id = $this->user_details['id'];
        if (!exists(['id' => $user_id], 'users')) {
            return response('user does not exist please enter valid user ID!', true);
        }
        $user_data = fetch_details('users_groups', ['user_id' => $user_id]);
        if (!empty($user_data) && isset($user_data[0]['group_id']) && !empty($user_data[0]['group_id']) && $user_data[0]['group_id'] == 3) {
            $user = fetch_details('users', ['id' => $user_id]);
            $partner_data = fetch_details('partner_details', ['partner_id' => $user_id]);

            $path = "/public/uploads/users/partners/";
            $profile_image = $user[0]['image'];

            $banner_path = "/public/uploads/users/partners/banner_images/";
            $banner_image = $partner_data[0]['banner'];

            $passport_path = "/public/uploads/users/passport/";
            $passport_image = $partner_data[0]['passport'];

            $profile_image = (file_exists(FCPATH . $path . $profile_image)) ? base_url($path . $profile_image) : ((file_exists(FCPATH . $profile_image)) ? base_url($profile_image) : ((!file_exists(FCPATH . $path . $profile_image)) ? base_url("public/backend/assets/profiles/default.png") : base_url($path . $profile_image)));
            $banner_image = (file_exists(FCPATH . $banner_path . $banner_image)) ? base_url($banner_path . $banner_image) : ((file_exists(FCPATH . $banner_image)) ? base_url($banner_image) : ((!file_exists(FCPATH . $banner_path . $banner_image)) ? base_url("public/backend/assets/profiles/default.png") : base_url($banner_path . $banner_image)));
            $passport_image = (file_exists(FCPATH . $passport_path . $passport_image)) ? base_url($passport_path . $passport_image) : ((file_exists(FCPATH . $passport_image)) ? base_url($passport_image) : ((!file_exists(FCPATH . $passport_path . $passport_image)) ? base_url("public/backend/assets/profiles/default.png") : base_url($passport_path . $passport_image)));
            // print_R($passport_image);
            // return;

            if (check_exists(base_url('public/backend/assets/profiles/' . $profile_image)) || check_exists(base_url('/public/uploads/users/partners/' . $profile_image)) || check_exists($profile_image)) {
                unlink($profile_image);
            }
            if (check_exists(base_url('/public/uploads/users/partners/banner_images/' . $banner_image)) || check_exists($banner_image)) {
                unlink($banner_image);
            }
            if (check_exists(base_url('/public/uploads/users/partners/banner_images/' . $passport_image)) || check_exists($passport_image)) {
                unlink($passport_image);
            }

            if (delete_details(['id' => $user_id], 'users') && delete_details(['user_id' => $user_id], 'users_groups')) {
                delete_details(['user_id' => $user_id], 'users_tokens'); // delete tokens of deleted user
                delete_details(['partner_id' => $user_id], 'promo_codes'); // delete promo code of deleted partner
                $slider_data = fetch_details('sliders', ['type' => 'services'], 'type_id');
                foreach ($slider_data as $row) {
                    $data = fetch_details('services', ['id' => $row['type_id']], 'user_id');
                    if ($data[0]['user_id'] == $user_id) {
                        delete_details(['type_id' => $row['type_id']], 'sliders'); // delete slider of deleted user service
                    }
                }
                return response('User account deleted successfully', false);
            } else {
                return response('User account does not delete', true);
            }
        } else {
            return response("This user's account can't delete ", true);
        }
    }
}
