<?php

namespace App\Models;

use CodeIgniter\Model;



class Partners_model extends Model
{
    protected $table = 'partner_details';
    protected $primaryKey = 'id';
    protected $allowedFields = ['partner_id', 'company_name', 'about', 'national_id', 'address', 'passport', 'banner', 'tax_name', 'tax_number', 'bank_name', 'account_number', 'account_name', 'bank_code', 'swift_code', 'advance_booking_days', 'type', 'number_of_members', 'admin_commission', 'visiting_charges', 'is_approved', 'service_range', 'ratings', 'number_of_ratings'];


    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $column_name = 'pd.id', $whereIn = [], $additional_data = [])
    {

        $multipleWhere = '';
        $db      = \Config\Database::connect();

        $builder = $db->table('partner_details pd');
        $values = ['7'];
        if ($search and $search != '') {
            $multipleWhere = [
                '`pd.id`' => $search,
                '`pd.company_name`' => $search,
                '`pd.tax_name`' => $search,
                '`pd.tax_number`' => $search,
                '`pd.bank_name`' => $search,
                '`pd.account_number`' => $search,
                '`pd.account_name`' => $search,
                '`pd.bank_code`' => $search,
                '`pd.swift_code`' => $search,
                '`pd.created_at`' => $search,
                '`pd.updated_at`' => $search,
                '`username`' => $search,
            ];
        }

        $builder->select(' COUNT(pd.id) as `total` ')->join('users u', 'pd.partner_id = u.id')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->where('ug.group_id', 3)->whereNotIn('pd.is_approved', $values);

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['max_serviceable_distance'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('pd.partner_id', $parnter_ids);
            }
        }
        $partner_count = $builder->get()->getResultArray();
        $total = $partner_count[0]['total'];


        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orLike($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['max_serviceable_distance'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('pd.partner_id', $parnter_ids);
            }
        }
        $builder->select('
            pd.*,
            u.username as partner_name,u.balance,u.image,u.active, u.email, u.phone, u.city,
            ug.user_id,ug.group_id,
            COUNT(DISTINCT CASE WHEN pd.partner_id then o.id END) as number_of_orders,

           
            MAX(DISTINCT CASE WHEN pd.partner_id then pc.discount END) as maximum_discount_percentage,
            MAX(DISTINCT CASE WHEN pd.partner_id then pc.max_discount_amount END) as maximum_discount_up_to
           
        ')
            ->join('users u', 'pd.partner_id = u.id')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->join('orders o', 'o.partner_id = pd.partner_id', 'left')
            ->join('promo_codes pc', 'pc.partner_id = pd.partner_id', 'left')
            ->where('ug.group_id', 3)
            ->groupBy('pd.partner_id');


        $partner_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($partner_record as $row) {
            if ($row['image'] != '') {
                if (check_exists(base_url('public/backend/assets/profiles/' . $row['image'])) || check_exists(base_url('/public/uploads/users/partners/' . $row['image'])) || check_exists($row['image'])) {
                    if (filter_var($row['image'], FILTER_VALIDATE_URL)) {
                        $profile = '<a  href="' .  $row['image'] . '" data-lightbox="image-1"><img height="80px" class="rounded-circle" src="' .  $row['image'] . '" alt=""></a>';
                    } else {
                        $row['image'] = (file_exists(FCPATH . 'public/backend/assets/profiles/' . $row['image'])) ? base_url('public/backend/assets/profiles/' . $row['image']) : ((file_exists(FCPATH . $row['image'])) ? base_url($row['image']) : ((!file_exists(FCPATH . "public/uploads/users/partners/" . $row['image'])) ? base_url("public/backend/assets/profiles/default.png") : base_url("public/uploads/users/partners/" . $row['image'])));
                        $profile = '<a  href="' . $row['image']  . '" data-lightbox="image-1"><img height="80px" class="rounded-circle" src="' . $row['image'] . '" alt=""></a>';
                    }
                } else {
                    $profile = '
                        <a href="#" id="pop">
                            <img id="profile_picture" src="' . base_url('public/backend/assets/profiles/default.png') . '" height="100px" class="rounded-circle">
                        </a>';
                }
            } else {
                $profile = '<a href="#" id="pop">
                        <img id="profile_picture" src="' . base_url('public/backend/assets/profiles/default.png') . '" height="100px" class="rounded-circle">
                    </a>';
            }

            if ($row['email'] != '' && $row['phone'] != "") {
                $contact_detail =
                    '<span>
                    ' . $row['email'] . '
                </span>';
            } elseif ($row['email'] != '') {
                $contact_detail = $row['email'];
            } else {
                $contact_detail = $row['phone'];
            }
            $profile =
                '<li class="media p-2" >' . $profile . ' <div class="media-body ml-2"> <div class="media-title ml-3 mt-3">' .     $row['partner_name'] . '</div>
            <div class="text-job text-muted">' . $contact_detail . '</div></div></li>';

            $status = "";

            $status =  ($row['is_approved'] == 1) ?
                '<button class="btn btn-warning disapprove_partner btn-sm"  title="Disapprove Partner"> <i class="fa fa-times" aria-hidden="true"></i> </button>' :
                '<button class="btn btn-success approve_partner btn-sm" title="Approve Partner"> <i class="fa fa-check" aria-hidden="true"></i> </button>';

            $status .= '<button class="btn btn-danger delete_partner ml-1 btn-sm" title = "Delete Partner"> <i class="fa fa-trash" aria-hidden="true"></i> </button>';
            $status .= '<a href="/admin/partners/view_partner/' . $row['partner_id'] . '" class="btn btn-info ml-1 btn-sm"  title = "view partner"> <i class="fa fa-eye" aria-hidden="true"></i> </a> ';
            $status .= '
            <button class="btn btn-primary btn-sm view_rating mt-1 ml-1" title = "View Partner Rating" data-toggle="modal" data-target="#view_rating_model">
                <i class="fa fa-star text-gold-rating" aria-hidden="true"></i> 
            </button>';

            if ($from_app) {

                // if (!empty($row['image'])) {
                //     if (check_exists(base_url('public/backend/assets/profiles/' . $row['image'])) || check_exists(base_url('/public/uploads/users/partners/' . $row['image'])) || check_exists($row['image'])) {
                //         $row['image'] = (file_exists(FCPATH . 'public/backend/assets/profiles/' . $row['image'])) ? base_url('public/backend/assets/profiles/' . $row['image']) : ((file_exists(FCPATH . $row['image'])) ? base_url($row['image']) : ((!file_exists(FCPATH . "public/uploads/users/partners/" . $row['image'])) ? base_url("public/backend/assets/profiles/default.png") : base_url("public/uploads/users/partners/" . $row['image'])));
                //     }
                //     // $row['image'] = (file_exists(base_url('public/backend/assets/profiles/' . $row['image']))) ? base_url('public/backend/assets/profiles/' . $row['image']) : (( file_exists(base_url($row['image'])) ) ? base_url($row['image']) : base_url('public/backend/assets/profiles/default.png'));
                //     $tempRow['image']  =  $row['image'];
                // } else {
                //     $tempRow['image'] = '';
                // }
                if (check_exists(base_url('public/backend/assets/profiles/' . $row['image'])) || check_exists(base_url('/public/uploads/users/partners/' . $row['image'])) || check_exists($row['image'])) {
                    if (filter_var($row['image'], FILTER_VALIDATE_URL)) {
                        $tempRow['image'] = $row['image'];
                    } else {
                        $row['image'] = (file_exists(FCPATH . 'public/backend/assets/profiles/' . $row['image'])) ? base_url('public/backend/assets/profiles/' . $row['image']) : ((file_exists(FCPATH . $row['image'])) ? base_url($row['image']) : ((!file_exists(FCPATH . "public/uploads/users/partners/" . $row['image'])) ? base_url("public/backend/assets/profiles/default.png") : base_url("public/uploads/users/partners/" . $row['image'])));
                        $tempRow['image'] = $row['image'];                    }
                }
                $tempRow['address'] = (!empty($row['address']) && isset($row['address'])) ? $row['address'] : '';
            }
            if (($row['type'] == 0)) {
                $type = "Individual";
            } else {
                $type = "Organization";
            }
            $label = ($row['is_approved'] == 1) ?
                '<div class="badge badge-success projects-badge"> Approved </div>' :
                '<div class="badge badge-warning projects-badge"> Disapproved </div>';

            $rating_data = $db->table('services s')
                ->select('
                count(sr.rating) as number_of_rating, 
                SUM(sr.rating) as total_rating,
                (SUM(sr.rating) / count(sr.rating)) as average_rating
                ')
                ->join('services_ratings sr', 'sr.service_id = s.id')
                ->where('s.user_id', $row['partner_id'])
                ->get()->getResultArray();

            if (!empty($row['banner'])) {

                // $row['banner'] = (file_exists(base_url('public/backend/assets/profiles/' . $row['banner']))) ? base_url('public/backend/assets/profiles/' . $row['banner']) : (( file_exists(base_url($row['banner'])) ) ? base_url($row['banner']) : base_url('public/backend/assets/profiles/default.png'));

                $row['banner'] = (file_exists(FCPATH . 'public/uploads/users/partners/banner_images/' . $row['banner'])) ? base_url('public/uploads/users/partners/banner_images/' . $row['banner']) : ((file_exists(FCPATH . $row['banner'])) ? base_url($row['banner']) : ((!file_exists(FCPATH . "public/uploads/users/partners/banner_images/" . $row['banner'])) ? base_url("public/backend/assets/profiles/default.png") : base_url("public/uploads/users/partners/banner_images/" . $row['banner'])));
                $tempRow['banner_image'] = $row['banner'];
            } else {
                $tempRow['banner_image'] = '';
            }

            $tempRow['id'] = $row['id'];
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['partner_profile'] = $profile;
            $tempRow['company_name'] = $row['company_name'];
            $tempRow['balance'] = $row['balance'];
            $tempRow['mobile'] = $row['phone'];
            $tempRow['about'] = $row['about'];
            $tempRow['address'] = (!empty($row['address']) && isset($row['address'])) ? $row['address'] : '';
            $tempRow['national_id'] = ($row['national_id'] != '') ?  base_url($row['national_id']) : '';
            $tempRow['passport'] = ($row['passport'] != '') ? base_url($row['passport']) : '';
            $tempRow['partner_name'] = $row['partner_name'];
            $tempRow['tax_name'] = $row['tax_name'];
            $tempRow['tax_number'] = $row['tax_number'];
            $tempRow['bank_name'] = $row['bank_name'];
            $tempRow['account_number'] = $row['account_number'];
            $tempRow['account_name'] = $row['account_name'];
            $tempRow['bank_code'] = $row['bank_code'];
            $tempRow['swift_code'] = $row['swift_code'];
            // $tempRow['advance_booking_days'] = $row['advance_booking_days'];
            $tempRow['number_of_members'] = $row['number_of_members'];
            $tempRow['admin_commission'] = $row['admin_commission'];
            $tempRow['type'] = $type;
            // $tempRow['image'] = $row['image'];
            $tempRow['advance_booking_days'] = $row['advance_booking_days'];
            $tempRow['number_of_members'] = $row['number_of_members'];
            $tempRow['ratings'] = $row['ratings'];
            $tempRow['number_of_ratings'] = $row['number_of_ratings'];
            $tempRow['visiting_charges'] = $row['visiting_charges'];
            $tempRow['contact_detail'] = $contact_detail;


            // $tempRow['comment'] = $row['comment'];


            if (check_partner_availibility($row['partner_id'])) {
                $tempRow['is_available_now'] = true;
            } else {
                $tempRow['is_available_now'] = false;
            }

            $tempRow['status'] = $label;
            if (!empty($rating_data)) {
                // $tempRow['ratings'] = ($rating_data[0]['average_rating'] != "") ? sprintf('%0.1f', $rating_data[0]['average_rating'])  : '00';
                // $tempRow['number_of_ratings'] = ($rating_data[0]['number_of_rating'] != "") ? (int) $rating_data[0]['number_of_rating'] : 0;
                if ($from_app == false) {
                    $tempRow['stars'] = '
                    <div class="partner-rating" id= "' . $row['id']  . '" data-value="' .  $tempRow['ratings']  . '"> </div>
                    <span> (' . number_format($tempRow['ratings'], 1)  . '/' .  $tempRow['number_of_ratings'] . ') </span>
                    ';
                }
            }

            // 
            $rate_data = get_ratings($row['partner_id']);	
            $tempRow['1_star'] = $rate_data[0]['rating_1'];	
            $tempRow['2_star'] = $rate_data[0]['rating_2'];	
            $tempRow['3_star'] = $rate_data[0]['rating_3'];	
            $tempRow['4_star'] = $rate_data[0]['rating_4'];	
            $tempRow['5_star'] = $rate_data[0]['rating_5'];
            // 



            if ($from_app == false) {
                $tempRow['discount'] =  $row['maximum_discount_percentage'];
                $tempRow['discount_up_to'] =  $row['maximum_discount_up_to'];

                $tempRow['is_approved'] = ($from_app == true) ? $row['is_approved'] : $status;
                $tempRow['created_at'] = $row['created_at'];
            } else {

                if (isset($additional_data['customer_id']) && !empty($additional_data['customer_id'])) {
                    $customer_id = $additional_data['customer_id'];
                    $is_favorite = is_favorite($customer_id, $row['partner_id']);

                    $tempRow['is_favorite'] = ($is_favorite) ? '1' : '0';
                }


                $tempRow['discount'] =  $row['maximum_discount_percentage'];
                $tempRow['discount_up_to'] =  $row['maximum_discount_up_to'];

                $tempRow['number_of_orders'] = $row['number_of_orders'];
                $tempRow['status'] = $row['is_approved'];


                unset($tempRow['partner_profile']);
                unset($tempRow['contact_detail']);
            }
            $rows[] = $tempRow;
        }
        if ($from_app) {
            $response['total'] = $total;
            $response['data'] = $rows;
            return $response;
        } else {
            $bulkData['rows'] = $rows;
        }
        return $bulkData;
    }

    public function unsettled_commission_list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $column_name = 'pd.id', $whereIn = [], $additional_data = [])
    {

        $multipleWhere = '';
        $db      = \Config\Database::connect();

        $builder = $db->table('partner_details pd');
        $values = ['7'];
        if ($search and $search != '') {
            $multipleWhere = [
                '`pd.id`' => $search,
                '`pd.company_name`' => $search,
                '`pd.tax_name`' => $search,
                '`pd.tax_number`' => $search,
                '`pd.bank_name`' => $search,
                '`pd.account_number`' => $search,
                '`pd.account_name`' => $search,
                '`pd.bank_code`' => $search,
                '`pd.swift_code`' => $search,
                '`pd.created_at`' => $search,
                '`pd.updated_at`' => $search,
            ];
        }

        $builder->select(' COUNT(pd.id) as `total` ')->join('users u', 'pd.partner_id = u.id')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->where('ug.group_id', 3)->whereNotIn('pd.is_approved', $values);

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['max_serviceable_distance'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('pd.partner_id', $parnter_ids);
            }
        }
        $partner_count = $builder->get()->getResultArray();

        $total = $partner_count[0]['total'];


        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orLike($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['city_id'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('pd.partner_id', $parnter_ids);
            }
        }
        $builder->select('pd.*,u.username as partner_name,u.balance,u.image,u.active, u.email, u.phone, ug.user_id,ug.group_id')
            ->join('users u', 'pd.partner_id = u.id')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->where('ug.group_id', 3);

        $builder->whereNotIn('pd.is_approved', $values);
        $partner_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($partner_record as $row) {


            $operations =  '<button class="btn btn-success btn-sm pay-out" data-toggle="modal" data-target="#exampleModal"> 
            <i class="fa fa-pencil" aria-hidden="true"></i> 
            </button> ';
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['balance'] = $row['balance'];
            $tempRow['company_name'] = $row['company_name'];

            $tempRow['operations'] = $operations;
            $tempRow['partner_name'] = $row['partner_name'];

            if ($from_app == false) {
                $tempRow['created_at'] = $row['created_at'];
            } else {
                $tempRow['status'] = $row['is_approved'];
            }
            $rows[] = $tempRow;
        }
        if ($from_app) {
            $response['total'] = $total;
            $response['data'] = $rows;
            return $response;
        } else {
            $bulkData['rows'] = $rows;
        }
        return $bulkData;
    }
}
