<?php

namespace App\Models;

use CodeIgniter\Model;

class Payment_request_model extends Model
{
    protected $table = 'payment_request';
    protected $primaryKey = 'id';
    protected $allowedFields = ['user_id', 'user_type', 'payment_address', 'amount', 'remarks', 'status'];

    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'DESC', $where = [])
    {
        $ionAuth = new \IonAuth\Libraries\IonAuth();
        $db      = \Config\Database::connect();
        $builder = $db->table('payment_request p');
        $multipleWhere = [];
        $condition = $bulkData = $rows = $tempRow = [];

        if (isset($_GET['offset']))
            $offset = $_GET['offset'];

        if ((isset($search) && !empty($search) && $search != "") || (isset($_GET['search']) && $_GET['search'] != '')) {
            $search = (isset($_GET['search']) && $_GET['search'] != '') ? $_GET['search'] : $search;
            $multipleWhere = [
                'p.id' => $search,
                'p.user_id' => $search,
                'p.user_type' => $search,
                'p.payment_address' => $search,
                'p.amount' => $search,
                'p.remarks' => $search,
                'p.status' => $search,
                'u.username' => $search,

            ];
        }

        if (isset($_GET['limit'])) {
            $limit = $_GET['limit'];
        }
        $sort = "p.id";
        if (isset($_GET['sort'])) {
            if ($_GET['sort'] == 'p.id') {
                $sort = "p.id";
            } else {
                $sort = $_GET['sort'];
            }
        }
        $order = "ASC";
        if (isset($_GET['order'])) {
            $order = $_GET['order'];
        }

        $count = $builder->select('count(p.id) as total')
            ->join('users u', 'u.id=p.user_id');


        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }

        $count = $builder->get()->getResultArray();
        $total = $count[0]['total'];


        $builder->select('p.*,pd.*,u.username as partner_name');

        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }

        $record = $builder->join('users u', 'u.id=p.user_id', 'left')
            ->join('partner_details pd', 'pd.partner_id=u.id', 'left')
            ->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        // print_r($record);



        foreach ($record as $row) {
            $operations = "";
            // '  
            // <button class="btn btn-danger btn-sm delete" data-id="' . $row['id'] . '"> <i class="fa fa-trash" aria-hidden="true"></i> </button> 
            // ';
            if ($row['status'] == 0) {
                if (isset($where['user_id']) && !empty($where['user_id'])) {
                    $operations .= '<button class="btn btn-success btn-sm edit" data-id="' . $row['id'] . '" data-toggle="modal" data-target="#update_modal"><i class="fa fa-pen" aria-hidden="true"></i> </button> ';
                }
                if ($ionAuth->isAdmin()) {
                    $operations .= '<button class="btn btn-success btn-sm edit_request" data-id="' . $row['id'] . '" data-toggle="modal" data-target="#edit_modal"><i class="fa fa-check" aria-hidden="true"></i> </button> ';
                }
            }
            if ($from_app) {
                if ($row['status'] == 0) {
                    $status = "Pending";
                } elseif ($row['status'] == 1) {
                    $status = "Approved";
                } else {
                    $status = "Rejected";
                }
            }
            if ($row['status'] == 0) {
                $status =  "<label class='badge badge-secondary'>Pending</label>";
            } elseif ($row['status'] == 1) {
                $status =  "<label class='badge badge-success'>Approved</label>";;
            } else {
                $status =  "<label class='badge badge-danger'>Rejected</label>";
            }
            $tempRow['id'] = $row['id'];
            $tempRow['user_id'] = $row['user_id'];
            $tempRow['partner_name'] = $row['partner_name'];
            $tempRow['bank_name'] = $row['bank_name'];
            $tempRow['account_number'] = $row['account_number'];
            $tempRow['account_name'] = $row['account_name'];
            $tempRow['bank_code'] = $row['bank_code'];
            $tempRow['swift_code'] = $row['swift_code'];
            $tempRow['user_type'] = $row['user_type'];
            $tempRow['payment_address'] = $row['payment_address'];
            $tempRow['amount'] = $row['amount'];
            $tempRow['remarks'] = $row['remarks'];
            $tempRow['status'] = $status;
            $tempRow['created_at'] =  date("d-M-Y h:i A", strtotime($row['created_at']));
            $tempRow['operations'] =  $operations;
            if ($from_app == true) {
                $tempRow['status'] =  strip_tags($status);
            } else {
                $tempRow['status'] =  $status;
            }
            $rows[] = $tempRow;
        }
        $bulkData['rows'] = $rows;
        if ($from_app) {
            // if request from app return array 
            $data['total'] = $total;
            $data['data'] = $rows;
            return $data;
        } else {
            // else return json
            return json_encode($bulkData);
        }
    }
}
