<?php

namespace App\Models;

use CodeIgniter\Model;

class Promo_code_model extends Model
{
    protected $table = 'promo_codes';
    protected $primaryKey = 'id';
    protected $allowedFields = ['partner_id', 'promo_code', 'message', 'start_date', 'end_date', 'no_of_users', 'minimum_order_amount', 'discount', 'discount_type', 'max_discount_amount', 'repeat_usage', 'no_of_repeat_usage', 'image', 'status'];

    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'DESC', $where = [])
    {

        $db      = \Config\Database::connect();
        $builder = $db->table('promo_codes pc');
        $multipleWhere = [];
        $condition = $bulkData = $rows = $tempRow = [];
        if ((isset($search) && !empty($search) && $search != "") || (isset($_GET['search']) && $_GET['search'] != '')) {
            $search = (isset($_GET['search']) && $_GET['search'] != '') ? $_GET['search'] : $search;
            $multipleWhere = [
                'pc.id' => $search,
                'pc.partner_id' => $search,
                'pc.promo_code' => $search,
                'pc.message' => $search,
                'pc.start_date' => $search,
                'pc.end_date' => $search,
            ];
        }


        if (isset($_GET['offset']))
            $offset = $_GET['offset'];

        if (isset($_GET['limit'])) {
            $limit = $_GET['limit'];
        }

        if (isset($_GET['sort'])) {
            if ($_GET['sort'] == 'pc.id') {
                $sort = "pc.id";
            } else {
                $sort = $_GET['sort'];
            }
        }
        if (isset($_GET['order'])) {
            $order = $_GET['order'];
        }

        $count =  $builder->select(' COUNT(pc.id) as `total` ');

        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }

        $count = $builder->get()->getResultArray();
        $total = $count[0]['total'];


        $builder->select('pc.*,p.username as partner_name');
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }
        if ($from_app) {
            $service_record = $builder->join('users p', 'p.id=pc.partner_id', 'left')->orderBy($sort, $order)->get()->getResultArray();
        } else {
            $service_record = $builder->join('users p', 'p.id=pc.partner_id', 'left')->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
        }
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($service_record as $row) {
            $image = "";
            if ((isset($row['image']) && !empty($row['image']))) {
                if (check_exists(base_url($row['image']))) {
                    $image = '<a  href="' . base_url($row['image'])  . '" data-lightbox="image-1"><img height="80px" class="rounded" src="' . base_url($row['image']) . '" alt=""></a>';
                }
            }

            $operations = '<button class="btn btn-danger btn-sm delete-promo_codes delete"> <i class="fa fa-trash" aria-hidden="true"></i> </button> ';
            if (isset($where['partner_id']) && !empty($where['partner_id'])) {
                $operations .= '<button class="btn btn-success btn-sm edit" data-id="' . $row['id'] . '" data-toggle="modal" data-target="#update_modal"><i class="fa fa-pen" aria-hidden="true"></i> </button> ';
            }

            if ($from_app) {
                $status =  ($row['status'] == 1) ? 'Enable' : 'Disable';
                $image = (isset($row['image']) && !empty($row['image'])) ?  base_url($row['image']) : "";
            }

            $status =  ($row['status'] == 1) ? '1' : '0';
            $tempRow['id'] = $row['id'];
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['partner_name'] = $row['partner_name'];
            $tempRow['promo_code'] = $row['promo_code'];
            $tempRow['message'] = $row['message'];
            $tempRow['start_date'] = $row['start_date'];
            $tempRow['end_date'] = $row['end_date'];
            $tempRow['no_of_users'] = $row['no_of_users'];
            $tempRow['minimum_order_amount'] = $row['minimum_order_amount'];
            $tempRow['discount'] = $row['discount'];
            $tempRow['discount_type'] = $row['discount_type'];
            $tempRow['max_discount_amount'] = $row['max_discount_amount'];
            $tempRow['repeat_usage'] = $row['repeat_usage'];
            $tempRow['no_of_repeat_usage'] = $row['no_of_repeat_usage'];
            $tempRow['image'] = $image;
            $tempRow['status'] = $row['status'];
            $tempRow['status'] = $status;
            $tempRow['created_at'] = $row['created_at'];
            if (!$from_app) {
                $tempRow['operations'] = $operations;
            }
            $rows[] = $tempRow;
        }
        $bulkData['rows'] = $rows;
        if ($from_app) {
            // if request from app return array 
            $data['total'] = $total;
            $data['data'] = $rows;
            return $data;
        } else {
            // else return json
            return json_encode($bulkData);
        }
    }
    public function admin_list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'DESC', $where = [])
    {

        $multipleWhere = '';
        $db      = \Config\Database::connect();

        $builder = $db->table('promo_codes pc');
        $values = ['7'];
        if ($search and $search != '') {
            $multipleWhere = [
                'pc.id' => $search,
                'pc.partner_id' => $search,
                'pc.promo_code' => $search,
                'pc.message' => $search,
                'username' => $search,
                'pc.start_date' => $search,
                'pc.end_date' => $search,
            ];
        }

        $builder->select('COUNT(pc.id) as `total` ')->join('users p', 'p.id=pc.partner_id', 'left');

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }


        $partner_count = $builder->get()->getResultArray();

        $total = $partner_count[0]['total'];


        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orLike($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }


        $builder->select('pc.*,p.username as partner_name')
            ->join('users p', 'p.id=pc.partner_id', 'left');


        $partner_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($partner_record as $row) {

            $image = "";
            if ((isset($row['image']) && !empty($row['image']))) {
                if (check_exists(base_url($row['image']))) {
                    $image = '<a  href="' . base_url($row['image'])  . '" data-lightbox="image-1"><img height="80px" class="rounded" src="' . base_url($row['image']) . '" alt=""></a>';
                }
            }

            $operations = '<button class="btn btn-danger btn-sm delete-promo_codes"> <i class="fa fa-trash" aria-hidden="true"></i> </button> ';
            if (isset($where['partner_id']) && !empty($where['partner_id'])) {
                $operations .= '<button class="btn btn-success btn-sm edit" data-id="' . $row['id'] . '" data-toggle="modal" data-target="#update_modal"><i class="fa fa-pen" aria-hidden="true"></i> </button> ';
            }

            if ($from_app) {
                $status =  ($row['status'] == 1) ? 'Enable' : 'Disable';
                $image = (isset($row['image']) && !empty($row['image'])) ?  base_url($row['image']) : "";
            }

            $status =  ($row['status'] == 1) ? 'Active' : 'Deactive';
            $tempRow['id'] = $row['id'];
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['partner_name'] = $row['partner_name'];
            $tempRow['promo_code'] = $row['promo_code'];
            $tempRow['message'] = $row['message'];
            $tempRow['start_date'] = $row['start_date'];
            $tempRow['end_date'] = $row['end_date'];
            $tempRow['no_of_users'] = $row['no_of_users'];
            $tempRow['minimum_order_amount'] = $row['minimum_order_amount'];
            $tempRow['discount'] = $row['discount'];
            $tempRow['discount_type'] = $row['discount_type'];
            $tempRow['max_discount_amount'] = $row['max_discount_amount'];
            $tempRow['repeat_usage'] = $row['repeat_usage'];
            $tempRow['no_of_repeat_usage'] = $row['no_of_repeat_usage'];
            $tempRow['image'] = $image;
            $tempRow['status'] = $row['status'];
            $tempRow['status'] = $status;
            $tempRow['created_at'] = $row['created_at'];
            if (!$from_app) {
                $tempRow['operations'] = $operations;
            }
            $rows[] = $tempRow;
        }
        if ($from_app) {
            $response['total'] = $total;
            $response['data'] = $rows;
            return $response;
        } else {
            $bulkData['rows'] = $rows;
        }
        return $bulkData;
    }
}
