<?php

namespace App\Models;

use CodeIgniter\Model;

class Service_model extends Model
{

    protected $table = 'services';
    protected $primaryKey = 'id';
    protected $allowedFields = [

        'user_id', 'category_id', 'tax_id', 'tax', 'title', 'slug',
        'description', 'tags', 'image', 'price', 'discounted_price', 'is_cancelable', 'cancelable_till', 'tax_type',
        'number_of_members_required', 'duration', 'rating', 'number_of_ratings', 'on_site_allowed', 'max_quantity_allowed', 'is_pay_later_allowed', 'status'
    ];
    public $admin_id;
    public function __construct()
    {
        $ionAuth = new \IonAuth\Libraries\IonAuth();
        $this->admin_id = ($ionAuth->isAdmin()) ? $ionAuth->user()->row()->id : 0;
        $this->ionAuth = new \IonAuth\Libraries\IonAuth();
    }

    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $additional_data = [], $column_name = '', $whereIn = [])
    {
        $multipleWhere = "";
        $db      = \Config\Database::connect();
        $builder = $db->table('services s');
        if ($search and $search != '') {
            $multipleWhere = [
                '`s.id`' => $search,
                '`s.title`' => $search,
                '`s.description`' => $search,
                '`s.status`' => $search,
                '`s.tags`' => $search,
                '`s.price`' => $search,
                '`s.discounted_price`' => $search,
                '`s.rating`' => $search,
                '`s.number_of_ratings`' => $search,
                '`s.max_quantity_allowed`' => $search,
                '`s.category_id`' => $search
            ];
           
        }
        $total  = $builder->select('COUNT(s.id) as `total` ');
        // $min_max_price = $builder->select('s.price');
        $max_price = $builder->select('MAX(s.price) as max_price');
        $min_price = $builder->select('MIN(s.price) as min_price');

        // $min_price = $builder->selectMin('s.price');




        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orWhere($multipleWhere);
            $builder->groupEnd();
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        if (!empty($whereIn)) {

            $builder->whereIn($column_name, $whereIn);
        }
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['max_serviceable_distance'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('s.user_id', $parnter_ids);
            }
        }

        $service_count = $builder->get()->getResultArray();

        $total = $service_count[0]['total'];
        $min_price = $service_count[0]['min_price'];
        $max_price = $service_count[0]['max_price'];


        $builder->select('s.*,c.name as category_name,p.username as partner_name,c.parent_id');

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        if (!empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['max_serviceable_distance'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('s.user_id', $parnter_ids);
                $service_record = $builder->join('users p', 'p.id=s.user_id', 'left')->join('categories c', 'c.id=s.category_id', 'left')->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
            }
        } else {
            $service_record = $builder->join('users p', 'p.id=s.user_id', 'left')->join('categories c', 'c.id=s.category_id', 'left')->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
        }
        
        $bulkData = array();
        $bulkData['total'] = $total;
        $bulkData['min_price'] = $min_price;
        $bulkData['max_price'] = $max_price;

        $rows = array();
        $tempRow = array();
        if (isset($service_record) && !empty($service_record)) {
            foreach ($service_record as $row) {
                $operations = "";
                if ($this->ionAuth->isAdmin()) {
                    $operations = '  
                
                <button class="btn btn-info btn-sm edit" data-toggle="modal" data-target="#exampleModal">                 
                <i class="fa fa-pencil" aria-hidden="true"></i> 
                </button> 
                ';
                }
                $operations .= '<button class="btn btn-danger btn-sm delete" data-id="' . $row['id'] . '"> 
            <i class="fa fa-trash" aria-hidden="true"></i> 
            </button> ';
                if (isset($where['user_id']) && !empty($where['user_id'])) {
                    $operations .= '<button class="btn btn-success btn-sm edit" data-id="' . $row['id'] . '" data-toggle="modal" data-target="#update_modal"><i class="fa fa-pen" aria-hidden="true"></i> </button> ';
                }
                if ($from_app) {
                    if (isset($row['image']) && !empty($row['image']) && check_exists(base_url($row['image']))) {
                        $images = base_url($row['image']);
                    } else {
                        $images = '';
                    }
                } else {
                    if (isset($row['image']) && !empty($row['image']) && check_exists(base_url($row['image']))) {
                        $images = '<a  href="' . base_url($row['image'])  . '" data-lightbox="image-1"><img height="80px" class="rounded" src="' . base_url($row['image']) . '" alt=""></a>';
                    } else {
                        $images = 'nothing found';
                    }
                }
                $is_cancelable =  ($row['is_cancelable'] == 1) ? "<span class='badge badge-success'>Yes</span>" : "<span class='badge badge-danger'>Not Allowed</span>";
                $status =  ($row['status'] == 1) ? 'Enable' : 'Disable';
                $site_allowed = ($row['on_site_allowed'] == 1) ? 'Allowed' : 'Not Allowed';
                $pay_later = ($row['is_pay_later_allowed'] == 1) ? '1' : '0';
                $rating = $row['rating'];

                json_decode($row['tags']);
                if (json_last_error() === JSON_ERROR_NONE) {
                    $tags = json_decode($row['tags']);
                } else {
                    $tags = $row['tags'];
                }

                // OPD area ends

                $tempRow['id'] = $row['id'];
                $tempRow['user_id'] = $row['user_id'];
                $tempRow['category_id'] = $row['category_id'];
                $tempRow['parent_id'] = $row['parent_id'];
                $tempRow['category_name'] = $row['category_name'];
                $tempRow['partner_name'] = $row['partner_name'];
                // $tempRow['tax_id'] = $row['tax_id'];
                $tempRow['tax'] = $row['tax'];
                $tempRow['tax_type'] = $row['tax_type'];
                $tempRow['title'] = $row['title'];
                $tempRow['slug'] = $row['slug'];
                $tempRow['description'] = $row['description'];
                $tempRow['tags'] = $tags;
                $tempRow['image_of_the_service'] = $images;
                $tempRow['price'] = $row['price'];
                $tempRow['discounted_price'] = $row['discounted_price'];
                $tempRow['number_of_members_required'] = $row['number_of_members_required'];
                $tempRow['duration'] = $row['duration'];
                $tempRow['rating'] = $rating;
                $tempRow['number_of_ratings'] = $row['number_of_ratings'];
                $tempRow['on_site_allowed'] = $site_allowed;
                $tempRow['max_quantity_allowed'] = $row['max_quantity_allowed'];

                $tempRow['is_pay_later_allowed'] = $pay_later;
                $tempRow['status'] = $status;
                $tempRow['created_at'] = $row['created_at'];
                $tempRow['cancelable_till'] = $row['cancelable_till'];
                $tempRow['cancelable'] = $row['is_cancelable'];

                if (!$from_app) {
                    $tempRow['operations'] = $operations;
                    $tempRow['is_cancelable'] = $is_cancelable;
                } else {
                    $tempRow['is_cancelable'] = $row['is_cancelable'];
                    $quantity =  (isset($additional_data['user_id']) && !empty($additional_data['user_id'])) ? in_cart_qty($row['id'], $additional_data['user_id']) : "";
                    $tempRow['in_cart_quantity'] =  $quantity;
                }
                $rows[] = $tempRow;
            }


            if ($from_app) {
                // if request from app return array 

                // print_r($data);
                $data['total'] = (empty($total)) ? (string) count($rows) : $total;
                $data['min_price'] = $min_price;
                $data['max_price'] = $max_price;
                $data['data'] = $rows;
                // print_r($data);
                return $data;
            } else {
                // else return json
                $bulkData['rows'] = $rows;
                return json_encode($bulkData);
            }
        } else {
            return false;
        }
    }
}
