<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('faqs', "FAQs") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">FAQs</a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <div class="row">
                <div class="col-md">
                    <h2 class='section-title'><?= labels('manage_faqs', "Manage FAQs") ?></h2>
                    <div class="card-body">
                        <?= form_open('admin/faqs/add_faqs', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_faqs', 'enctype' => "multipart/form-data"]); ?>
                        <div class="form-group">
                            <label for="question">Quetion</label>
                            <input id="question" class="form-control" type="text" name="question" placeholder="Enter the Question here">
                        </div>
                        <div class="form-group">
                            <label for="answer">Answer</label>
                            <textarea id="answer" class="form-control" name="answer" placeholder="Enter the Answer here"></textarea>
                        </div>
                        <button type="reset" class="btn btn-warning">Reset</button>
                        <button type="submit" class="btn btn-success">Add FAQs</button>
                        <?= form_close(); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid card">
            <h2 class='section-title'><?= labels('faqs', "FAQs") ?></h2>
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <table class="table table-striped" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/faqs/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="DESC">
                            <thead>
                                <tr>
                                    <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                    <th data-field="question" class="text-center" data-sortable="true"><?= labels('question', 'Question') ?></th>
                                    <th data-field="answer" class="text-center" data-sortable="true"><?= labels('answer', 'Answer') ?></th>
                                    <th data-field="created_at" class="text-center" data-visible="false" data-sortable="true"><?= labels('created_at', 'Created At') ?></th>
                                    <th data-field="operations" class="text-center" data-events="faqs_events"><?= labels('operations', 'Operations') ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- update modal -->
    <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit FAQs</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- <form action="" method="post"> -->
                    <?= form_open('admin/faqs/edit_faqs', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'edit_faqs', 'enctype' => "multipart/form-data"]); ?>
                    <input type="hidden" name="id" id="id">
                    <div class="form-group">
                        <label for="title">Question</label>
                        <input id="edit_question" class="form-control" type="question" name="question" placeholder="Enter the title here">
                    </div>
                    <div class="form-group">
                        <label for="title">Answer</label>
                        <textarea id="edit_answer" class="form-control col-md-12" name="answer" placeholder="Enter The Answer Here"></textarea>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" name="submit">Save changes</button>
                    <?php form_close() ?>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


</div>