<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('sliders', "Sliders") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">Sliders</div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <div class="row">
                <div class="col-md">
                    <h2 class='section-title'><?= labels('create_sliders', "Create Sliders") ?></h2>
                    <div class="card-body">
                        <?= form_open('/admin/sliders/add_slider', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_Category', 'enctype' => "multipart/form-data"]); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">Type <small> sliders</small> </label>
                                    <select id="type" class="form-control" name="type">
                                        <option value="">Select Type </option>
                                        <option value="default">Default </option>
                                        <option value="Category">Category </option>
                                        <option value="services">Service </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="categories" id="categories_select">
                                        <label for="Category_item">Category</label>

                                        <select id="Category_item" class="form-control" name="Category_item">
                                            <option value="">Select Category</option>
                                            <?php foreach ($categories_name as $Category) : ?>
                                                <option value="<?= $Category['id'] ?>"><?= $Category['name'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="services" id="services_select">
                                        <label for="service_item">Service</label>

                                        <select id="service_item" class="form-control" name="service_item">
                                            <option value="">Select Service</option>
                                            <?php foreach ($services_title as $service) : ?>
                                                <option value="<?= $service['id'] ?>"><?= $service['title'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="slider_image">Upload</span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="Image" name="image" aria-describedby="slider_image" accept="image/*">
                                            <label class="custom-file-label" for="image">Choose file</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="slider_switch" name="slider_switch" checked>
                                        <label class="custom-control-label" for="slider_switch">
                                            <span id="slider_text">
                                                Enable
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group">
                                    <button type="reset" class="btn btn-warning">Reset</button>
                                    <button type="submit" class="btn btn-success">Add Slider</button>
                                </div>
                            </div>
                        </div>
                        <?= form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid card">
            <h2 class='section-title'>Slider details</h2>
            <div class="row">
                <div class="col-lg">
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="col-md">
                                <table class="table table-striped" id="slider_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/sliders/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, Al
                            
                            l]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                                    <thead>
                                        <tr>
                                            <th data-field="id" class="text-center" data-visible="true" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                            <th data-field="type" class="text-center" data-visible="true" data-sortable="true"><?= labels('type', 'type') ?></th>
                                            <th data-field="type_id" class="text-center" data-visible="true" data-sortable="true"><?= labels('type_id', 'type_id') ?></th>
                                            <th data-field="slider_image" class="text-center" data-visible="true"><?= labels('image', 'Image') ?></th>
                                            <th data-field="status" class="text-center" data-sortable="true"><?= labels('status', 'Status') ?></th>
                                            <th data-field="created_at" class="text-center" data-sortable="true"><?= labels('created_at', 'Created At') ?></th>
                                            <th data-field="operations" class="text-center" data-events="slider_events"><?= labels('operations', 'Operations') ?></th>

                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- update Modal -->
    <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Slider</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?= form_open('/admin/sliders/update_slider', ['method' => "post", 'class' => 'update-form-submit-event', 'id' => 'update_slider', 'enctype' => "multipart/form-data"]); ?>
                    <input type="hidden" name="id" id="id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <h6>select type from here</h6>
                                <select id="type_1" class="form-control" name="type_1">
                                    <option value="">Select Type </option>
                                    <option value="default">Default </option>
                                    <option value="Category">Category </option>
                                    <option value="services">Service </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group ">
                                <div class="categories" id="categories_select_1">
                                    <label for="Category_item">Choose a Category</label>

                                    <select id="Category_item_1" class="form-control" name="Category_item_1">
                                    <option value="">Select Category </option>
                                        <?php foreach ($categories_name as $Category) : ?>
                                            <option value="<?= $Category['id'] ?>"><?= $Category['name'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="services" id="services_select_1">
                                    <label for="service_item">Choose a Service</label>

                                    <select id="service_item_1" class="form-control" name="service_item_1">
                                    <option value="">Select Service </option>
                                        <?php foreach ($services_title as $service) : ?>
                                            <option value="<?= $service['id'] ?>"><?= $service['title'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md">
                            <img src="" alt="old_image" id="offer_image" class="w-50">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md">
                            <div class="form-group">
                                <div class="input-group mb-3">
                                    <div class="mb-3">
                                        <label for="formFile" class="form-label">Sliders</label>
                                        <input class="form-control" type="file" id="formFile" name="image" accept="image/*">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md">
                            <div class="form-group">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="edit_slider_switch" name="edit_slider_switch" checked>
                                    <label class="custom-control-label" for="edit_slider_switch">
                                        <span id="edit_slider_text">
                                            Enable
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update Slider</button>
                    <?php form_close() ?>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>