<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('system_users', "System Users") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">System Users</a></div>
            </div>
        </div>

        <div class="section-body">
            <div class="container-fluid card">

                <div class="row">
                    <div class="col-md">
                        <h2 class='section-title'><?= labels('system_user', "System User") ?></h2>
                        <div class="row mt-3">
                            <div class="col-md">
                                <a href="<?= base_url('/admin/system_users/add_user') ?>" class="btn btn-primary float-right">Add System User</a>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg">
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <div class="col-md">
                                            <table class="table table-striped" id="system_user_list" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/system_users/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                                                <thead>
                                                    <tr>
                                                        <th data-field="id" class="text-center" data-visible="true" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                                        <th data-field="username" class="text-center" data-visible="true" data-sortable="true"><?= labels('user_name', 'User Name') ?></th>
                                                        <th data-field="email" class="text-center" data-visible="true" data-sortable="true"><?= labels('email', 'E-Mail') ?></th>
                                                        <th data-field="role" class="text-center" data-visible="true" data-sortable="true"><?= labels('role', 'Role') ?></th>

                                                        <th data-field="operations" class="text-center" data-visible="true" data-sortable="true" data-events="user_events">
                                                            <?= labels('operations', 'Operations') ?>
                                                        </th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</div>
</section>
</div>


<div class="modal fade" id="edit_permission" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Edit permission Model</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="<?= base_url('admin/system_users/edit_permit') ?>" method="post" class="form-submit-event" id="edit-permit">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md">
                                <input type="hidden" name="id" id="id">
                                <div class="form-group">
                                    <label for="edit_role">Edit Role</label>
                                    <select id="edit_role" class="form-control" name="edit_role">
                                        <option value="0" selected>Select Role</option>
                                        <option value="1">Super Admin</option>
                                        <option value="2">Admin</option>
                                        <option value="3">Editor</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="permissions">
                        <div class="col-md">
                            <div class="table-responsive">
                                <table class="table permission-table">
                                    <tbody>
                                        <tr>
                                            <th>Module/Permissions</th>
                                            <th>Create</th>
                                            <th>Read</th>
                                            <th>Update</th>
                                            <th>Delete</th>
                                        </tr>
                                    </tbody>
                                    <tbody>
                                        <?php foreach ($permissions as $perms => $value) : ?>
                                            <tr>
                                                <td>
                                                    <?= $perms ?>

                                                    <!-- <?php print_r($value) ?> -->
                                                    <!-- <?php print_r((!empty($value[1]) ? $value[1] : "no data")) ?> -->
                                                </td>

                                                <td class="align-baseline">
                                                    <?php
                                                    $i;
                                                    $cust_id =  $perms . "_create_edit"
                                                    ?>
                                                    <!-- <?= $cust_id ?> -->
                                                    <?php for ($i = 0; $i < count($value); $i++) : ?>
                                                        <?php if ($value[$i] == "create") : ?>
                                                            <div class="custom-control custom-switch">
                                                                <input id="<?= $cust_id ?>" class="custom-control-input" type="checkbox" name="<?= $cust_id ?>" value="true">
                                                                <label for="<?= $cust_id ?>" class="custom-control-label">
                                                                </label>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endfor; ?>
                                                </td>
                                                <td class="align-baseline">
                                                    <?php
                                                    $cust_id_read =  $perms . "_read_edit";
                                                    ?>
                                                    <!-- <?= $cust_id_read ?> -->
                                                    <?php for ($i = 0; $i < count($value); $i++) : ?>
                                                        <?php if ($value[$i] == "read") : ?>
                                                            <div class="custom-control custom-switch">
                                                                <input id="<?= $cust_id_read ?>" class="custom-control-input" type="checkbox" name="<?= $cust_id_read ?>" value="true">
                                                                <label for="<?= $cust_id_read ?>" class="custom-control-label">
                                                                </label>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endfor; ?>
                                                </td>
                                                <td class="align-baseline">

                                                    <?php $cust_id_update =  $perms . "_update_edit" ?>
                                                    <!-- <?= $cust_id_update ?> -->
                                                    <?php for ($i = 0; $i < count($value); $i++) : ?>
                                                        <?php if ($value[$i] == "update") : ?>
                                                            <div class="custom-control custom-switch">
                                                                <input id="<?= $cust_id_update ?>" class="custom-control-input" type="checkbox" name="<?= $cust_id_update ?>" value="true">
                                                                <label for="<?= $cust_id_update ?>" class="custom-control-label">
                                                                </label>
                                                            </div>
                                                        <?php else : ?>
                                                        <?php endif ?>
                                                        <?php ?>
                                                    <?php endfor ?>

                                                </td>

                                                <td class="align-baseline">
                                                    <?php $cust_id_delete =  $perms . "_delete_edit"  ?>
                                                    <!-- <?= $cust_id_delete ?> -->
                                                    <?php for ($i = 0; $i < count($value); $i++) : ?>
                                                        <?php if ($value[$i] == "delete") : ?>
                                                            <div class="custom-control custom-switch">
                                                                <input id="<?= $cust_id_delete ?>" class="custom-control-input" type="checkbox" name="<?= $cust_id_delete ?>" value="true">
                                                                <label for="<?= $cust_id_delete ?>" class="custom-control-label">
                                                                </label>
                                                            </div>
                                                        <?php else : ?>
                                                        <?php endif ?>
                                                        <?php ?>
                                                    <?php endfor ?>
                                                    <!--  -->
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Save changes</button>
                </form>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>