<?php $data = get_settings('general_settings', true); ?>
<div class="navbar-bg"></div>
<nav class="navbar navbar-expand-lg main-navbar">
    <form class="form-inline mr-auto">
        <ul class="navbar-nav mr-3">
            <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg"><i class="fas fa-bars"></i></a></li>
            <?php  if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) { ?>
            <li class="nav-item my-auto ml-2">
                <span class="badge badge-danger">Demo mode</span>
            </li>
            <?php } ?>
            <li><a href="#" data-toggle="search" class="nav-link nav-link-lg d-sm-none"><i class="fas fa-search"></i></a></li>
        </ul>
    </form>
    <ul class="navbar-nav navbar-right">
        <li class="dropdown">
            <a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user">

                <div class="d-inline-block"><?= strtoupper($current_lang) ?>
                </div>
            </a>
            <div class="dropdown-menu dropdown-menu-right">
                <?php foreach ($languages_locale as $language) { ?>
                    <span onclick="set_locale('<?= $language['code'] ?>')" class="dropdown-item has-icon <?= ($language['code'] == $current_lang) ? "text-primary" : "" ?>">
                        <?= strtoupper($language['code']) . " - "  . ucwords($language['language']) ?>
                    </span>
                <?php } ?>
            </div>
        </li>

        <li class="dropdown">
            <a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                <?= $profile_picture ?>
                <div class="d-inline-block"><?= labels('hello', 'Hi') ?> , <?= $user ?>
                </div>
            </a>
            <div class="dropdown-menu dropdown-menu-right">
                <a href="<?= base_url('admin/profile') ?>" class="dropdown-item has-icon">
                    <i class="far fa-user"></i> <?= labels('profile', "Profile") ?>
                </a>
                <div class="dropdown-divider"></div>
                <a href="<?= base_url('auth/logout') ?>" class="dropdown-item has-icon text-danger">
                    <i class="fas fa-sign-out-alt"></i> <?= labels('logout', "Logout") ?>
                </a>
            </div>
        </li>
    </ul>
</nav>
<div class="main-sidebar">
    <aside id="sidebar-wrapper">
        <div class="sidebar-brand">
            <a href="<?= base_url('admin/') ?>">
                <img src=" <?= isset($data['logo']) && $data['logo'] != "" ? base_url("public/uploads/site/" . $data['logo']) : base_url('public/backend/assets/img/news/img01.jpg') ?>" class="sidebar_logo w-max-90 h-max-60px" alt="">
            </a>
        </div>
        <div class="sidebar-brand sidebar-brand-sm">
            <a href="<?= base_url('admin/') ?>">
                <img src="<?= isset($data['half_logo']) && $data['half_logo'] != "" ? base_url("public/uploads/site/" . $data['half_logo']) : base_url('public/backend/assets/img/news/img01.jpg') ?>" height="40px" alt="">
            </a>
        </div>
        <ul class="sidebar-menu">

            <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/dashboard/') ?>">
                    <i class="fas fa-home text-info"></i> <span><?= labels('Dashboard', 'Dashboard') ?></span></span></a>
            </li>


            <li class="dropdown">
                <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-handshake text-primary"></i> <span>Providers</span></a>
                <ul class="dropdown-menu" style="display: none;">
                    <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/partners'); ?>"><i class="	fas fa-handshake text-warning"></i> <span><?= labels('providers', 'Providers') ?></span></span></a></li>

                    <li>
                        <a class="nav-link" href="<?= base_url('admin/partners/payment_request'); ?>">
                            <i class="fas fa-money-bill-wave text-success"></i>
                            <span><?= labels('payment_request', "Payment Request") ?></span></a>
                    </li>
                    <li>
                        <a class="nav-link" href="<?= base_url('admin/partners/settle_commission'); ?>">
                            <i class="far fa-handshake"></i>
                            <span><?= labels('manage_commission', "Settlements") ?></span></a>
                    </li>
                </ul>
            </li>

            <!-- <li>
                <a class="nav-link" href="<?= base_url('admin/cities') ?>"><i class="fas fa-map text-success"></i><span><?= labels('cities', "Cities") ?></span></a>
            </li> -->

            <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/orders') ?>"><i class="fas fa-dolly-flatbed text-warning"></i> <span><?= labels('orders', 'Orders') ?></span></span></a></li>
            <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/categories') ?>"><i class="fas fa-list-alt text-success"></i> <span><?= labels('categories', 'Categories') ?></span></span></a></li>
            <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/services'); ?>"><i class="	fas fa-tools text-info"></i> <span><?= labels('services', 'Services') ?></span></span></a></li>
            <!-- <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/offers'); ?>"><i class="fas fa-gift text-primary"></i><span><?= labels('offers', 'Offers') ?>
                    </span></span></a>
            </li> -->
            <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/sliders'); ?>"><i class="	fas fa-flag text-danger"></i> <span><?= labels('sliders', 'Sliders') ?></span></span></a></li>
            <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/Featured_sections') ?>"><i class="fas fa-list-alt text-info"></i> <span><?= labels('featured', 'Featured Section') ?></span></span></a></li>
            <li class="dropdown">
                <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-users text-warning"></i> <span>Customers</span></a>
                <ul class="dropdown-menu" style="display: none;">
                    <li><a class="nav-link" href="<?= base_url('/admin/users/'); ?>"><i class="fas fa-users text-success"></i> <span><?= labels('customers', "Customers") ?></span></span></a></li>
                    <li><a class="nav-link" href="<?= base_url('/admin/transactions'); ?>"><i class="fas fa-file-invoice-dollar text-primary"></i> <span><?= labels('transactions', "Transactions") ?></span></span></a></li>
                    <li><a class="nav-link" href="<?= base_url('/admin/addresses'); ?>"><i class="far fa-address-book nav-icon text-danger"></i><span><?= labels('addresses', 'Addresses') ?></span></a></li>
                </ul>
            </li>
            <!-- <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/taxes'); ?>"><i class="fas fa-percent text-danger"></i><span><?= labels('Taxes', 'Taxes') ?></span></span></a></li> -->

            <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/promo_codes'); ?>"><i class="fas fa-puzzle-piece text-primary"></i><span><?= labels('promocode', 'Promo codes') ?>
                    </span></span></a>
            </li>
            <!-- <li class="dropdown">
                <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-comment text-warning"></i> <span>Complaint System</span></a>
                <ul class="dropdown-menu" style="display: none;">
                    <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/tickets'); ?>"><i class="fas fa-money-bill-wave text-warning"></i> <span><?= labels('tickets_type', 'Ticket Types') ?></span></span></a></li>

                    <li class="nav-item"><a class="nav-link" href="<?= base_url('/admin/show_tickets') ?>"><i class="fas fa-wallet text-danger"></i> <span><?= labels('tickets', 'Tickets') ?></span></span></a></li>
                </ul>
            </li> -->

            <li class="nav-item dropdown">
                <a href="#" class="nav-link has-dropdown"><i class="fas fa-cog  text-info"></i> <span><?= labels('settings', "Settings") ?></span></a>
                <ul class="dropdown-menu">
                    <li><a class="nav-link" href="<?= base_url('admin/settings/general-settings') ?>"><?= labels('general_settings', "General Settings") ?></a></li>
                    <li><a class="nav-link" href="<?= base_url('admin/settings/email-settings') ?>"><?= labels('smtp_email', "SMTP (Email)") ?></a></li>
                    <li><a class="nav-link" href="<?= base_url('admin/settings/pg-settings') ?>"><?= labels('payment_gateway', "Payment Gateway") ?></a></li>
                    <li><a class="nav-link" href="<?= base_url('admin/settings/api_key_settings') ?>"> <?= labels('api_key_settings', "Api Key Settings") ?></a></li>
                    <!-- <li><a class="nav-link" href="<?= base_url('admin/settings/app_settings') ?>"> <?= labels('app_settings', "App Settings") ?></a></li> -->
                    <li><a class="nav-link" href="<?= base_url('admin/languages') ?>"> <?= labels('languages', "Languages") ?></a></li>
                    <li><a class="nav-link" href="<?= base_url('admin/settings/system_tax_settings') ?>"> <?= labels('system_tax_settings', "System Tax Settings") ?></a></li>
                    <li><a class="nav-link" href="<?= base_url('admin/settings/updater') ?>"><?= labels('system_updater', "System Updater") ?></a></li>
                </ul>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="<?= base_url('/admin/system_users'); ?>"><i class="fas fa-user text-danger"></i><span><?= labels('system_users', 'System Users') ?></span></span></a>
            </li>
            <li>
                <a class="nav-link" href="<?= base_url('/admin/notification'); ?>"><i class="fas fa-bell text-warning"></i><span><?= labels('send_notifications', "Send notifications") ?></span></span></a>
            </li>
            <li>
                <a class="nav-link" href="<?= base_url('admin/faqs') ?>"><i class="fas fa-question-circle text-info"></i> <span><?= labels('faqs', "FAQs") ?></span></span></a>
            </li>
            <!-- <li>
                <a class="nav-link" href="<?= base_url('admin/test') ?>"><i class="fas fa-question-circle text-info"></i> <span><?= labels('test', "Test") ?></span></span></a>
            </li> -->
        </ul>
    </aside>
</div>