<!-- Main Content -->

<div class="main-content">
    <section class="section">
        <div class="section-header">

            <h1><?= labels('dashboard', "Dashboard") ?></h1>
            <div class="section-header-breadcrumb">
            </div>
        </div>


        <div class="row mb-4">
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                <div class="card card-statistic-1 shadow">
                    <div class="card-icon pt-1">
                        <i class="fa-brands fa-opencart display-4 text-primary"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?= labels('total_orders', 'Total Orders') ?></h4>
                        </div>

                        <div class="card-body">
                            <span class="counter"><?= $total_orders ?></span>
                        </div>
                    </div>

                </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                <div class="card card-statistic-1 shadow">
                    <div class="card-icon pt-2">
                        <i class="fa-solid fa-screwdriver-wrench display-4 text-warning"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?= labels('total_services', 'Total Services') ?></h4>
                        </div>

                        <div class="card-body">
                            <span class="counter"><?= $total_services ?></span>
                        </div>
                    </div>

                </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                <div class="card card-statistic-1 shadow">
                    <div class="card-icon pt-2">
                        <i class="fa-solid fa-wallet display-4 text-danger"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?= labels('pending_amount', 'Pending Earnings') ?></h4>
                        </div>

                        <div class="card-body">
                            <span class=""><?= $currency . '&nbsp;' . ($total_balance) ?></span>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                <div class="card card-statistic-1 shadow">
                    <div class="card-icon pt-2">
                        <i class="fa-solid fa-star text-success display-4"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?= labels('total_ratings', 'Total Ratings') ?></h4>
                        </div>

                        <div class="card-body">
                            <span class=""><?= $total_ratings . '&#47;' .  $number_of_ratings ?></span>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="container-fluid">
            <h2 class="section-title"><?= labels('assets_statistics', "Assets Statistics") ?></h2>
            <div class="card">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card-header">
                            <h4><?= labels('sales_chart', "Sales Chart") ?></h4>
                        </div>
                        <div class="card-body">
                            <canvas id="sales" class="p-5" aria-label="chart" role="img"></canvas>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card-header">
                            <h4><?= labels('category_wise_service_count', 'Category Wise Service Count') ?></h4>
                        </div>
                        <div class="card-body">
                            <canvas id="pieChart" class="p-5" aria-label="chart" role="img"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
    $(document).ready(() => {
        if ($("#sales").length > 0) {
            var ctx = document.getElementById('sales').getContext('2d');
            var total_sale = [];
            var month_name;
            var data = [];
            $.ajax({
                type: "get",
                url: siteUrl + '/partner/dashboard/fetch_sales',
                cache: false,
                dataType: 'json',
                success: function(result) {
                    total_sale = result.total_sale
                    month_name = result.month_name
                    var data = {
                        labels: month_name,
                        datasets: [{
                            label: 'total sale of month',
                            backgroundColor: [
                                'rgba(255, 99, 132, 0.2)',
                                'rgba(255, 159, 64, 0.2)',
                                'rgba(255, 205, 86, 0.2)',
                                'rgba(75, 192, 192, 0.2)',
                                'rgba(54, 162, 235, 0.2)',
                                'rgba(153, 102, 255, 0.2)',
                                'rgba(201, 203, 207, 0.2)'
                            ],
                            borderColor: [
                                'rgb(255, 99, 132)',
                                'rgb(255, 159, 64)',
                                'rgb(255, 205, 86)',
                                'rgb(75, 192, 192)',
                                'rgb(54, 162, 235)',
                                'rgb(153, 102, 255)',
                                'rgb(201, 203, 207)'
                            ],
                            borderWidth: 1,
                            data: total_sale,
                        }]
                    };

                    var config = {
                        type: 'bar',
                        data: data,
                        options: {}
                    };
                    var myChart = new Chart(
                        document.getElementById('sales'),
                        config
                    );

                }
            });
        }
        if ($("#pieChart").length > 0) {
            var ctx = document.getElementById('pieChart').getContext('2d');
            $.ajax({
                type: "get",
                url: siteUrl + '/partner/dashboard/fetch_data',
                cache: false,
                dataType: 'json',
                success: function(result) {
                    var category = ''

                    Object.keys(result.category).map((key) => {
                        labels = result.category[key];
                        category = labels.split(",")

                    });
                    const data = {
                        labels: result.category,
                        datasets: [{
                            label: 'sale',
                            data: result.counter,
                            backgroundColor: [
                                'rgb(255, 99, 132)',
                                'rgb(255, 159, 64)',
                                'rgb(255, 205, 86)',
                                'rgb(75, 192, 192)',
                                'rgb(54, 162, 235)',
                                'rgb(153, 102, 255)',
                                'rgb(201, 203, 207)'
                            ],
                            hoverOffset: 4
                        }]
                    };

                    const config = {
                        type: 'doughnut',
                        data: data,
                    };
                    const myChart = new Chart(
                        document.getElementById('pieChart'),
                        config
                    );
                }
            });
        }
    });
</script>