<?= helper('form'); ?>
<div class="main-content">
    <div class="section">
        <div class="section-header">
            <h1><?= labels('add_service', 'Add Service') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/partner/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item"><a href="<?= base_url('/partner/services') ?>"> Services</a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <h2 class='section-title '><?= labels('add_service', "Add Service") ?></h2>
            <div class="row">
                <div class="col-md-12">
                    <?= form_open('/partner/services/add_service', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_service', 'enctype' => "multipart/form-data"]); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="title">Title of the service</label>
                                <input class="form-control" type="text" name="title">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="jquery-script-clear"></div>
                            <div class="categories" id="categories">
                                <label for="category_item">Choose a Category for your service</label>
                                <select id="category_item" class="form-control" name="categories">
                                    <option value=""> Select Category</option>
                                    <?php foreach ($categories as $category) : ?>
                                        <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="sub_category"><?= labels('sub_category ', 'Sub Categories') ?></label>
                                <input type="text" class="form-control" name="sub_category" id="sub_category" placeholder="" value="">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group mt-4">
                                <label for="tags">Tags</label>
                                <input id="service_tags" class="" type="text" name="tags[]">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="tax_type">Tax Type</label>
                                <select name="tax_type" id="tax_type" class="form-control">
                                <option value="excluded">Tax Excluded In Price</option>
                                <option value="included">Tax Included In Price</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md">
                            <div class="form-group mb-1">
                                <label for="tax">Tax <small>in percentage(%)</small></label>
                                <input id="tax" class="form-control" type="text" name="tax" value="<?= $tax['tax'] ?>" data-value="1" readonly>
                            </div>
                        </div>
                        <!-- <div class="col-md-6">
                            <div class="form-group mb-1">
                                <label for="tax_id">Select Tax</label>
                                <select name="tax_id" class=" form-control">
                                    <?php foreach ($tax_details as $tax_detail) : ?>
                                        <option value="<?= $tax_detail['id'] ?>"><?= $tax_detail['title'] ?> (<?= $tax_detail['percentage'] ?>%)</option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div> -->
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="custom-file">
                                <div class="form-group">
                                    <?= labels('service_image', "Service Image") ?>
                                    <input type="file" class="custom-file-input" id="image" name="image" accept='image/*' onchange="readURL(this)">
                                    <label class="custom-file-label mt-4" for="image">Choose file</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 mt-3">
                            <div class="form-group">
                                <img src="<?= base_url('public/backend/assets/img/news/img01.jpg') ?>" alt="Service Image" width="30%" id="service_image">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="price">Price</label>
                                <input id="price" class="form-control" type="text" name="price" placeholder="price">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="discounted_price">Discounted Price</label>
                                <input id="discounted_price" class="form-control" type="text" name="discounted_price" placeholder="Discounted Price">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="on_site" name="on_site">
                                <label class="custom-control-label" for="on_site">On Site Allowed</label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="pay_later" name="pay_later">
                                <label class="custom-control-label" for="pay_later">Pay Later Allowed</label>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_cancelable" name="is_cancelable">
                                <label class="custom-control-label" for="is_cancelable">Is Cancelable ?</label>
                            </div>
                        </div>
                        <div class="col-lg-3 cancelable-till">
                            <div class="form-group">
                                <label for="cancelable_till">Cancelable before</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <span>Minutes</span>
                                        </div>
                                    </div>
                                    <input type="text" class="form-control" name="cancelable_till" id="cancelable_till" placeholder="Ex. 30" value="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="members">Members Required to Perform Task</label>
                                <input id="members" class="form-control" type="text" name="members" placeholder="Members Required">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="duration"><?= labels('duration_to_perform_task', 'Duration to Perform Task') ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <span>Minutes</span>
                                        </div>
                                    </div>
                                    <input type="text" class="form-control" name="duration" id="duration" placeholder="Duration of the Service">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg">
                            <div class="form-group">
                                <label for="max_qty">Max Quantity allowed for services</label>
                                <input id="max_qty" class="form-control" type="text" name="max_qty" placeholder="Max Quantity allowed for services">
                            </div>
                        </div>
                        <div class="col-lg">
                            <div class="form-group">
                                <label for="Description">Description</label>
                                <textarea rows='10' cols='30' class='form-control h-50' name="description"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-2">
                            <div class="form-group">
                                <input type="submit" value="Add Service" id="service_submit" class="btn btn-success btn-block">
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <input type="reset" value="Reset" class="btn btn-danger btn-block">
                            </div>
                        </div>
                    </div>
                    <?= form_close() ?>
                </div>
            </div>
        </div>
    </div>
</div>