<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('invoice', 'Invoice') ?></h1>
        </div>
        <?= session("message"); ?>
        <?php if (!empty($order)) { ?>
            <div class="section">
                <div class="section-body">
                    <div class="card card-flush invoice section-to-print">
                        <div class="col-md-12 text-right">
                            <div id="section-not-to-print">
                                <button type="button" value="Print this page" onclick="{window.print()};" class="btn btn-default"><i class="fa fa-print"></i> Print</button>
                            </div>
                            <div class="invoice-title d-flex justify-content-between">
                                <div class="invoice-number"><?= "#INVOC-" . $order['id'] ?></div>
                            </div>
                        </div>

                        <div class="invoice-print">
                            <div class="col-md-12 col-sm-12 d-flex justify-content-between">
                                <div>
                                    <strong>Billed From:</strong><br>
                                    <address>
                                        <?= labels('company_name', 'Company') ?> : <?= $order['company_name'] ?><br>
                                        <?= labels('address', 'Address') ?> : <?= $order['address'] ?><br>
                                        <?= labels('partner_no', 'Partner No') ?> : <?= $order['partner_no'] ?><br>
                                        <strong><?= $order['tax_name'] ?></strong><?= " : " . $order['tax_number'] ?>
                                        <div class="mt-2">
                                            <strong>Payment Method:</strong><br>
                                            <?= $order['payment_method'] ?><br>
                                        </div>
                                    </address>
                                </div>
                                <hr>
                                <address>
                                    <strong>Billed To:</strong><br>
                                    <?= labels('customer_name', 'Name') ?> : <?= $order['customer'] ?><br>
                                    <?= labels('customer_no', 'No') ?> : <?= $order['customer_no'] ?><br>
                                    <?= labels('customer_email', 'Email') ?> : <?= $order['customer_email'] ?><br>
                                    <div class="mt-2">
                                        <strong>Order Date:</strong><br>
                                        <?= $order['date_of_service'] ?><br>
                                    </div>
                                    <div class="mt-2">
                                        <strong>Order Status:</strong><br>
                                        <?= $order['status'] ?><br><br>
                                    </div>
                                </address>
                            </div>
                        </div>
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="section-title">Order Summary</div>
                                <div class="table-responsive">
                                    <table class="table table-hover table-borderd" id="invoice_table" data-show-export="true" data-export-types="['txt','excel','csv']" data-export-options='{"fileName": "invoice-order-list","ignoreColumn": ["action"]}' data-auto-refresh="true" data-toggle="table" data-search-highlight="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-url="<?= base_url('partner/orders/invoice_table/' . $order['id']); ?>" data-sort-order="DESC">
                                        <thead>
                                            <tr>
                                                <th data-field="service_title" data-sortable="true" data-visible="true">Service</th>
                                                <th data-field="price" data-sortable="true" data-visible="true">Price</th>
                                                <th data-field="quantity" data-sortable="true" data-visible="true">Quantity</th>
                                                <th data-field="subtotal" data-sortable="true" data-visible="true">Subtotal</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        <?php } else { ?>
            <div class="section">
                <div class="section-body">
                    <div class="invoice">
                        <div class="invoice-print">
                            <div class="row">
                                <div class="col-md-12 col-sm-12 d-flex justify-content-between">
                                    <h2 class="text-left invoice-logo">
                                        <img class="d-block img-fluid">
                                    </h2>
                                </div>
                                <h6 class="text-left">
                                    </h2>
                                    <address>
                                        Address: <br>
                                        Contact: <br>
                                        <strong></strong>
                                    </address>
                                    <div class="invoice-title col-md-12 col-sm-12 d-flex justify-content-between">
                                        <h2>Invoice</h2>
                                    </div>
                                    <div class="invoice-number"> "#INVOC-"</div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <address>
                                                <strong>Billed To:</strong><br>
                                            </address>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <address>
                                                <strong>Payment Method:</strong><br>
                                                <br>
                                            </address>
                                        </div>
                                        <div class="col-md-6 text-md-right">
                                            <address>
                                                <strong>Order Date:</strong><br>
                                                <br><br>
                                            </address>
                                        </div>
                                    </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="section-title">Order Summary</div>
                                <p class="section-lead">All items here cannot be deleted.</p>
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover table-md">

                                    </table>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-lg-8">
                                        <div class="section-title">Payment Method</div>
                                        <p class="section-lead">The payment method that we provide is to make it easier for you to pay invoices.</p>
                                        <div class="images">

                                        </div>
                                    </div>
                                    <div class="col-lg-4 text-right">
                                        <div class="invoice-detail-item">
                                            <div class="invoice-detail-name">Subtotal</div>
                                            <div class="invoice-detail-value"></div>
                                        </div>
                                        <div class="invoice-detail-item">
                                            <div class="invoice-detail-name">Shipping</div>
                                            <div class="invoice-detail-value"></div>
                                        </div>
                                        <hr class="mt-2 mb-2">
                                        <div class="invoice-detail-item">
                                            <div class="invoice-detail-name">Total</div>
                                            <div class="invoice-detail-value invoice-detail-value-lg"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        <?php } ?>

    </section>
</div>