<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('view orders', "View Order") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/partner/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">View Orders</a></div>
            </div>
        </div>
        <?= helper('form'); ?>
        <div class="section-body">
            <div class="row">
                <div class="col-md">
                    <div class="card border border-primary">
                        <div class="card-header bg-navy border-0 h5">
                            <h4>Order Summary</h4>
                        </div>
                        <div class="card-body">
                            <ul class="nav flex-column">
                                <li class="nav-item">
                                    <label class="bold"> Order No : <?= !empty($order_details['invoice_no']) ? $order_details['invoice_no'] : "" ?> </label>
                                </li>
                                <li class="nav-item">
                                    <label class="bold"> Company name : <?= !empty($order_details['company_name']) ? $order_details['company_name'] : "" ?> </label>
                                </li>
                                <li class="nav-item">
                                    <label class="bold"> Partner name : <?= !empty($order_details['partner']) ? $order_details['partner'] : "" ?> </label>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md">
                            <table class="table table-hover table-borderd" id="invoice_table" data-show-export="true" data-export-types="['txt','excel','csv']" data-export-options='{"fileName": "invoice-order-list","ignoreColumn": ["action"]}' data-auto-refresh="true" data-toggle="table" data-search-highlight="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-url="<?= base_url('partner/orders/order_summary_table/' . $order_details['id']); ?>" data-sort-order="DESC">
                                <thead>
                                    <tr>
                                        <th data-field="service_title" data-sortable="true" data-visible="true"><?= labels('services_summary', 'Services Summary') ?></th>
                                        <th data-field="price" data-sortable="true" data-visible="true"><?= labels('price', 'Price') ?></th>
                                        <th data-field="quantity" data-sortable="true" data-visible="true">Quantity</th>
                                        <th data-field="subtotal" data-sortable="true" data-visible="true">Subtotal</th>
                                        <th data-field="operations" data-sortable="true" data-events="order_service_event" data-visible="true">Operations</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                        <div class="card">
                            <div class="card-header bg-navy border-0 h5">
                                <h4><?= labels('order_status', "Order Status") ?>:</h4>
                            </div>
                            <div class="form-group col-md">
                                <select name="status" id="status" class="form-control update_order_status">
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="pending" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "pending") ? "selected" : "" ?>>Pending</option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="awaiting" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "awaiting") ? "selected" : "" ?>>Awaiting</option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="confirmed" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "confirmed") ? "selected" : "" ?>>Confirmed</option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="rescheduled" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "rescheduled") ? "selected" : "" ?>>Rescheduled</option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="cancelled" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "cancelled") ? "selected" : "" ?>>Cancelled</option>
                                    <option data-customer_id="<?= $order_details["customer_id"] ?>" data-order_id="<?= $order_details["id"] ?>" value="completed" <?= (isset($order_details['status']) && !empty($order_details['status']) && $order_details['status'] == "completed") ? "selected" : "" ?>>Completed</option>
                                </select>
                            </div>

                            <div class="row m-0">
                                <div class="col-md">
                                    <div class="form-group rescheduled_date">
                                        <label for="rescheduled_date">Rescheduled Date</label>
                                        <input id="rescheduled_date" class="form-control" type="date" name="rescheduled_date">
                                    </div>
                                </div>
                            </div>
                            <div class="row m-0">
                                <div class="col-sm mt-2">
                                    <div class="row" id="available-slots">

                                    </div>
                                </div>
                            </div>
                            <div class="row m-0">
                                <div class="col-md mt-3">
                                    <input type="hidden" name="order_id" id="order_id" value="<?= $order_details['id'] ?>">
                                    <button class="btn btn-block btn-primary form-control w-25" id="change_status">
                                        Update Status
                                    </button>
                                </div>
                            </div>
                            <p class="order-detail-p reschedulable"></p>
                        </div>
                    </div>
                </div>
                <div class="col-md">
                    <div class="card border border-success">
                        <div class="card-header bg-navy border-0 h5">
                            <h4>Customer Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="card card-widget widget-user-2">
                                <div class="widget-user-header bg-info">
                                    <input type="hidden" name="hidden" id="order_id" value="id">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <label for="" class="bold">Name:</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Contact:</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Email</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">User Wallet Balance</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Service Date</label>
                                        </li>
                                        <li class="nav-item">
                                            <label class="bold">Order City </label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">OTP </label>
                                        </li>
                                    </ul>
                                </div>

                                <div class="col-md-6">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <label for="" class="bold"> <?= !empty($order_details['customer']) ? $order_details['customer'] : "" ?> </label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"> <?= !empty($order_details['customer_no']) ? $order_details['customer_no'] : "" ?> </label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"> <?= !empty($order_details['customer_email']) ? $order_details['customer_email'] : "" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['user_wallet']) ? $currency . $order_details['user_wallet']  : "" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['date_of_service']) ? $order_details['date_of_service'] : "" ?> </label>
                                        </li>
                                        <li class="nav-item">
                                            <label class="bold"><?= get_city($order_details['city_id']) ?></label>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card border border-info">
                        <div class="card-header bg-navy border-0 h5">
                            <h4>Payment Deatails</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <label for="" class="bold">Payment Method</label>:
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Wallet Balance</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Promo Code </label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Service Charge</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Tax Amount (<?= $tax ?>%)</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Total</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold">Promo Code Discount</label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"> Payable Total</label>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md">
                                    <ul class="nav flex-column">
                                    <?php $total_tax_amount = 0.0;
                                    $total_tax_amount =  ($subtotal * $tax)/100; ?>

                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['payment_method']) ? $order_details['payment_method'] : "" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['user_wallet']) ? $currency . $order_details['user_wallet']  : 0 ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['promo_code']) ? $order_details['promo_code'] : "" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['visiting_charges']) ? $currency . $order_details['visiting_charges']  : 0 ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($total_tax_amount) ? $currency . $total_tax_amount  : 0 ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= !empty($order_details['total']) ? $currency . $subtotal  : "" ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <label for="" class="bold"><?= $currency . $promocode_discount  ?></label>
                                        </li>
                                        <li class="nav-item">
                                            <?php $total = intval(($subtotal + $order_details['visiting_charges'] + $total_tax_amount) - $promocode_discount);  ?>
                                            <label for="" class="bold"><?= !empty($total) ?  $currency . $total : "" ?></label>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
</div>