<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('orders', 'Orders') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/partner/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item">Orders</div>
            </div>
        </div>
        <div class="container-fluid card">
            <div class="row mt-3">
                <div class="col-md-2">
                    <div class="form-group">
                        <label for="order_status_filter"><?= labels('filter_orders', 'Filter Orders by Status') ?></label>
                        <select name="order_status_filter" id="order_status_filter" class="form-control selectric">
                            <option value="">-Select-</option>
                            <option value="awaiting">Awaiting</option>
                            <option value="confirmed">Confirmed</option>
                            <option value="rescheduled">Rescheduled</option>
                            <option value="cancelled">Cancelled</option>
                            <option value="completed">Completed</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label for=""><?= labels('apply_filters', 'Apply filters') ?></label>
                        <button class="btn btn-primary d-block" id="filter">
                            <?= labels('apply', 'Apply') ?>
                        </button>
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-md col-lg col-sm">
                    <table class="table table-striped" data-detail-view="true" data-detail-formatter="detailFormatter" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("partner/orders/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="DESC" data-query-params="orders_query">
                        <thead>
                            <tr>
                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="date_of_service" class="text-center"><?= labels('date_of_service', 'Date of Service') ?></th>
                                <th data-field="invoice_no" class="text-center" data-visible="false" data-sortable="true"><?= labels('invoice_no', 'Invoice No') ?></th>
                                <th data-field="user_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('user_id', 'User id') ?></th>
                                <th data-field="customer" class="text-center" data-sortable="true"><?= labels('customer', 'Customer') ?></th>
                                <th data-field="final_total" class="text-center" data-visible="true"><?= labels('final_total', 'Final total') ?></th>
                                <th data-field="partner" class="text-center" data-sortable="true" data-visible="false"><?= labels('provider', 'Provider') ?></th>
                                <th data-field="city_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('city_id', 'city_id') ?></th>
                                <th data-field="total" class="text-center" data-visible="false"><?= labels('total', 'Total') ?></th>
                                <th data-field="promo_code" class="text-center" data-visible="false"><?= labels('promo_code', 'Promo code') ?></th>
                                <th data-field="promo_discount" class="text-center" data-visible="false"><?= labels('promo_discount', 'Promo discount') ?></th>
                                <th data-field="admin_earnings" class="text-center" data-visible="false"><?= labels('Admin earnings', 'admin_earnings') ?></th>
                                <th data-field="partner_earnings" class="text-center" data-visible="false"><?= labels('Provider earnings', 'provider_earnings') ?></th>
                                <th data-field="address_id" class="text-center" data-visible="false"><?= labels('address_id', 'Address id') ?></th>
                                <th data-field="address" class="text-center"><?= labels('address', 'Address') ?></th>
                                <th data-field="visiting_charges" class="text-center" data-visible="false"><?= labels('visiting_charges', 'Visiting Charges') ?></th>
                                <th data-field="starting_time" class="text-center"><?= labels('starting_time', 'Starting time') ?></th>
                                <th data-field="ending_time" class="text-center"><?= labels('ending_time', 'Ending time') ?></th>
                                <th data-field="duration" class="text-center" data-visible="false"><?= labels('duration', 'Duration') ?></th>
                                <th data-field="status" class="text-center"><?= labels('status', 'Status') ?></th>
                                <th data-field="remarks" class="text-center" data-visible="false"><?= labels('remarks', 'Remarks') ?></th>
                                <th data-field="operations" class="text-center" data-events="orders_events"><?= labels('operations', 'Operations') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>


    <!-- To deactivate given selected user -->
    <div class="modal fade" id="deactivate_user_modal" tabindex="-1" role="dialog" aria-labelledby="deactivate_user_modal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Deactivate user</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?= base_url('admin/users/deactivate') ?>" method="post" id="deactivate_user_form">
                        <input type="hidden" name="user_id" id="user_id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="deactive_btn">Deactivate User</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- To activate given selected user -->
    <div class="modal fade" id="activate_user_modal" tabindex="-1" role="dialog" aria-labelledby="activate_user_modal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Activate user</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?= base_url('admin/users/activate') ?>" method="post" id="activate_user_form">
                        <input type="hidden" name="user_id" id="user_id_active">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="activate_btn">Activate User</button>
                    </form>
                </div>
            </div>
        </div>
    </div>