<!-- Main Content -->
<?= helper('form'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('promo_codes', 'Promo codes') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/partner/dashboard') ?>">Dashboard</a></div>
                <div class="breadcrumb-item"><a href="<?= base_url('/partner/promo_codes/add') ?>">Add Promocodes</a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <div class="row">
                <div class="col-md">
                    <h2 class='section-title'><?= labels('list_of_promocodes', "List of Promocodes") ?></h2>
                </div>
                <div class="col-md text-right m-auto">
                    <a class="btn btn-primary text-white" id="add_promo" href="<?= base_url('partner/promo_codes/add'); ?>"><i class="fas fa-plus"></i> <?= labels('add_promo_code', 'Add Promo Code') ?></a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-bordered table-hover" data-detail-view="true" data-detail-formatter="detailFormatter" id="promocode_table" data-auto-refresh="true" data-show-columns="true" data-show-toggle="true" data-show-refresh="true" data-toggle="table" data-search-highlight="true" data-server-sort="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-url="<?= base_url("partner/promo_codes/list") ?>" data-side-pagination="server" data-pagination="true" data-search="true" data-sort-name="id" data-sort-order="DESC">
                        <thead>
                            <tr>
                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="promo_code" class="text-center" data-sortable="true"><?= labels('promo_code', 'Promo code') ?></th>
                                <th data-field="image" class="text-center" data-sortable="true"><?= labels('image', 'Image') ?></th>
                                <th data-field="message" class="text-center" data-visible="false"><?= labels('message', 'Message') ?></th>
                                <th data-field="start_date" class="text-center"><?= labels('start_date', 'Start date') ?></th>
                                <th data-field="end_date" class="text-center"><?= labels('end_date', 'end_date') ?></th>
                                <th data-field="no_of_users" class="text-center" data-visible="false" data-sortable="true"><?= labels('	no_of_users', '	no_of_users') ?></th>
                                <th data-field="minimum_order_amount" class="text-center" data-visible="false" data-sortable="true"><?= labels('minimum_order_amount', 'minimum_order_amount') ?></th>
                                <th data-field="discount" class="text-center" data-visible="false"><?= labels('discount', 'discount') ?></th>
                                <th data-field="discount_type" class="text-center" data-visible="false"><?= labels('discount_type', 'discount_type') ?></th>
                                <th data-field="max_discount_amount	" class="text-center" data-visible="false" data-sortable="true"><?= labels('max_discount_amount	', 'max_discount_amount	') ?></th>
                                <th data-field="repeat_usage" class="text-center" data-visible="false"><?= labels('repeat_usage', 'repeat_usage') ?></th>
                                <th data-field="no_of_repeat_usage" class="text-center" data-visible="false"><?= labels('no_of_repeat_usage', 'no_of_repeat_usage') ?></th>
                                <th data-field="status" class="text-center" data-sortable="true"><?= labels('status', 'status') ?></th>
                                <th data-field="operations" class="text-center" data-events="promo_codes_events"><?= labels('operations', 'Operations') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Promo Code</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <?= form_open('partner/promo_codes/save', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'promo_code_form', 'enctype' => "multipart/form-data"]); ?>
                <input type="hidden" name="promo_id" id="id">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="promo_code"><?= labels('promocode', 'Promocode') ?></label>
                            <input type="text" class="form-control" id="promo_code" name="promo_code">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="start_date"><?= labels('start_date', 'Start Date') ?></label>
                            <input type="text" class="form-control datepicker" id="start_date" name="start_date">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="end_date"><?= labels('end_date', 'End Date') ?></label>
                            <input type="text" class="form-control datepicker" id="end_date" name="end_date">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="message"><?= labels('message', 'Message') ?></label>
                            <textarea class="form-control" name="message" id="message" cols="50" rows="10"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="no_of_users"><?= labels('no_of_users', 'No. of users') ?></label>
                            <input type="number" class="form-control" id="no_of_users" name="no_of_users">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="minimum_order_amount"><?= labels('minimum_order_amount', 'Minimum order amount') ?></label>
                            <input type="number" class="form-control" id="minimum_order_amount" name="minimum_order_amount">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="discount"><?= labels('discount', 'Discount') ?></label>
                            <input type="number" class="form-control" id="discount" name="discount">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="discount_type"><?= labels('discount_type', 'Discount Type') ?></label>
                            <select name="discount_type" id="discount_type" class="form-control">
                                <option value="amount">Amount</option>
                                <option value="percentage">Percentage</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 form-group">
                        <label class="custom-switch mt-2">
                            <input type="checkbox" id="repeat_usage" name="repeat_usage" class="custom-switch-input">
                            <span class="custom-switch-indicator"></span>
                            <span class="custom-switch-description"><?= labels('repeat_usage', 'Repeat Usage ?') ?></span>
                        </label>
                    </div>
                    <div class="col-md-6 repeat_usage">
                        <div class="form-group">
                            <label for="no_of_repeat_usage"><?= labels('no_of_repeat_usage', 'No. of repeat usage') ?></label>
                            <input type="number" class="form-control" id="no_of_repeat_usage" name="no_of_repeat_usage">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="max_discount_amount"><?= labels('max_discount_amount', 'Max Discount Amount') ?></label>
                            <input type="number" class="form-control" id="max_discount_amount" name="max_discount_amount">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="image"><?= labels('image', 'Image') ?></label>
                            <input type="file" class="form-control" id="image" name="image">
                            <div id="image_edit">

                            </div>

                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="custom-switch mt-2">
                        <input type="checkbox" name="status" class="custom-switch-input">
                        <span class="custom-switch-indicator"></span>
                        <span class="custom-switch-description"><?= labels('status', 'Status') ?></span>
                    </label>
                </div>

            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Save changes</button>
                <?php form_close() ?>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>