<?php

namespace App\Controllers\admin;

use CodeIgniter\Database\Query;

class Settings extends Admin
{
    private $db, $builder;
    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
        $this->validation = \Config\Services::validation();
        $this->builder = $this->db->table('settings');
    }

    public function __destruct()
    {
        $this->db->close();
        $this->data = [];
    }

    public function general_settings()
    {
        helper('form');
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if ($this->request->getPost('update')) {

                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }
                $this->validation->setRules(
                    [
                        'company_title' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter name for company name"
                            ]
                        ],
                        'support_name' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter name for support name"
                            ]
                        ],
                        'support_email' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter name for support email"
                            ]
                        ],
                        'currency' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please enter currency"
                            ]
                        ],
                        'system_timezone' => [
                            "rules" => 'required|trim',
                            "errors" => [
                                "required" => "Please select time zone"
                            ]
                        ],
                        'phone' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter phone number",
                                "numeric" => "Please enter numeric value for phone number"
                            ]
                        ],
                        'max_serviceable_distance' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter max serviceable distance",
                                "numeric" => "Please enter numeric value for max serviceable distance"
                            ]
                        ],
                        'address' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter address"
                            ]
                        ],
                        'copyright_details' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter copyright details"
                            ]
                        ],
                        'support_hours' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter support hours"
                            ]
                        ],
                       
                    ],
                );
                if (!$this->validation->withRequest($this->request)->run()) {
                    $errors  = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;

                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];
                    return $this->response->setJSON($response);
                }
                $updatedData = $this->request->getPost();
              

                $flag = 0;
                $favicon = false;
                $halfLogo = false;
                $logo = false;
                $partner_favicon = false;
                $partner_halfLogo = false;
                $partner_logo = false;
                $files = array();
                $data = get_settings('general_settings', true);
                if ($_FILES['favicon']['name'] != "") {
                    if (!valid_image('favicon')) {
                        $flag = 1;
                    } else {
                        $favicon = true;
                    }
                }
                if ($_FILES['halfLogo']['name'] != "") {
                    if (!valid_image('halfLogo')) {
                        $flag = 1;
                    } else {
                        $halfLogo = true;
                    }
                }
                if ($_FILES['logo']['name'] != "") {
                    if (!valid_image('logo')) {
                        $flag = 1;
                    } else {
                        $logo = true;
                    }
                }
                if ($_FILES['partner_favicon']['name'] != "") {
                    if (!valid_image('partner_favicon')) {
                        $flag = 1;
                    } else {
                        $partner_favicon = true;
                    }
                }
                if ($_FILES['partner_halfLogo']['name'] != "") {
                    if (!valid_image('partner_halfLogo')) {
                        $flag = 1;
                    } else {
                        $partner_halfLogo = true;
                    }
                }
                if ($_FILES['partner_logo']['name'] != "") {
                    if (!valid_image('partner_logo')) {
                        $flag = 1;
                    } else {
                        $partner_logo = true;
                    }
                }
                if ($favicon) {
                    $file = $this->request->getFile('favicon');
                    $path = FCPATH . 'public/uploads/site/';
                    $image = $file->getName();
                    $newName = $file->getRandomName();
                    $file->move($path, $newName);
                    $updatedData['favicon'] = $newName;
                } else {

                    $updatedData['favicon'] = isset($data['favicon']) ? $data['favicon'] : "";
                }
                if ($logo) {
                    $file = $this->request->getFile('logo');
                    $path = FCPATH . 'public/uploads/site/';
                    $image = $file->getName();
                    $newName = $file->getRandomName();
                    $file->move($path, $newName);
                    $updatedData['logo'] = $newName;
                } else {

                    $updatedData['logo'] = isset($data['logo']) ? $data['logo'] : "";
                }
                if ($halfLogo) {
                    $file = $this->request->getFile('halfLogo');
                    $path = FCPATH . 'public/uploads/site/';
                    $image = $file->getName();
                    $newName = $file->getRandomName();
                    $file->move($path, $newName);
                    $updatedData['half_logo'] = $newName;
                } else {

                    $updatedData['half_logo'] = isset($data['half_logo']) ? $data['half_logo'] : "";
                }
                if ($partner_favicon) {
                    $file = $this->request->getFile('partner_favicon');
                    $path = FCPATH . 'public/uploads/site/';
                    $image = $file->getName();
                    $newName = $file->getRandomName();
                    $file->move($path, $newName);
                    $updatedData['partner_favicon'] = $newName;
                } else {

                    $updatedData['partner_favicon'] = isset($data['partner_favicon']) ? $data['partner_favicon'] : "";
                }
                if ($partner_logo) {
                    $file = $this->request->getFile('partner_logo');
                    $path = FCPATH . 'public/uploads/site/';
                    $image = $file->getName();
                    $newName = $file->getRandomName();
                    $file->move($path, $newName);
                    $updatedData['partner_logo'] = $newName;
                } else {

                    $updatedData['partner_logo'] = isset($data['partner_logo']) ? $data['partner_logo'] : "";
                }
                if($updatedData['system_timezone_gmt'] == " 00:00"){
                    $updatedData['system_timezone_gmt'] = '+'.trim($updatedData['system_timezone_gmt']);
                }
                if ($partner_halfLogo) {
                    $file = $this->request->getFile('partner_halfLogo');
                    $path = FCPATH . 'public/uploads/site/';
                    $image = $file->getName();
                    $newName = $file->getRandomName();
                    $file->move($path, $newName);
                    $updatedData['partner_half_logo'] = $newName;
                } else {

                    $updatedData['partner_half_logo'] = isset($data['partner_half_logo']) ? $data['partner_half_logo'] :'';
                }
                if($updatedData['system_timezone_gmt'] == " 00:00"){
                    $updatedData['system_timezone_gmt'] = '+'.trim($updatedData['system_timezone_gmt']);
                }


                unset($updatedData['update']);
                unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);
               
                if ($flag == 0) {

                    if ($this->update_setting('general_settings', $json_string)) {
                        $_SESSION['toastMessage']  = 'Unable to update the settings.';
                        $_SESSION['toastMessageType']  = 'error';
                    } else {
                        $_SESSION['toastMessage'] = 'Settings has been successfuly updated.';
                        $_SESSION['toastMessageType']  = 'success';
                    }
                } else {
                    $_SESSION['toastMessage'] = 'please insert valid image.';
                    $_SESSION['toastMessageType']  = 'error';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/general-settings')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'general_settings');
            $query = $this->builder->get()->getResultArray();

            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                if (!empty($settings)) {
                    $this->data = array_merge($this->data, $settings);
                }
            }
            $this->data['timezones'] = get_timezone_array();
            $this->data['title'] = 'General Settings | Admin Panel';
            $this->data['main_page'] = 'general_settings';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function email_settings()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if ($this->request->getGet('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }
                $this->validation->setRules(
                    [
                        'smtpHost' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter SMTP Host"
                            ]
                        ],
                        'smtpUsername' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter SMTP Username"
                            ]
                        ],
                        'smtpPassword' => [
                            "rules" => 'required',
                            "errors" => [
                                "required" => "Please enter SMTP Password"
                            ]
                        ],
                        'smtpPort' => [
                            "rules" => 'required|numeric',
                            "errors" => [
                                "required" => "Please enter SMTP Port Number",
                                "numeric" => "Please enter numeric value for SMTP Port Number"
                            ]
                        ],
                        
                    ],
                );
                if (!$this->validation->withRequest($this->request)->run()) {
                    
                    $errors  = $this->validation->getErrors();
                    $response['error'] = true;
                    $response['message'] = $errors;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    $response['data'] = [];
                    return $this->response->setJSON($response);
                }
                // $this->validation->setRules(
                //     [
                //         'smtpHost' => 'required',
                //         'smtpUsername' => 'required',
                //         'smtpPassword' => 'required',
                //         'smtpPort' => 'required',
                //     ]
                // );
                // if (!$this->validation->withRequest($this->request)->run()) {
                //     $errors  = $this->validation->getErrors();
                //     $response['error'] = true;
                //     $response['message'] = $errors;
                   
                //     // $response['csrfName'] = csrf_token();
                //     // $response['csrfHash'] = csrf_hash();
                //     $response['data'] = [];
                //     return $this->response->setJSON($response);
                // }

                $updatedData = $this->request->getGet();
                $json_string = json_encode($updatedData);

                if ($this->update_setting('email_settings', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the email settings.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'Email settings has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/email-settings')->withCookies();
            }

            $this->builder->select('value');
            $this->builder->where('variable', 'email_settings');
            $query = $this->builder->get()->getResultArray();

            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'Email Settings | Admin Panel';
            $this->data['main_page'] = 'email_settings';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function pg_settings()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {

            if ($this->request->getPost('update')) {

                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }

                $updatedData = $this->request->getPost();

                unset($updatedData['update']);
                unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('payment_gateways_settings', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the payment gateways settings.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'Payment gate ways settings has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                    $this->session->markAsFlashdata('toastMessage');
                    $this->session->markAsFlashdata('toastMessageType');
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/pg-settings')->withCookies();
            } else {


                $this->builder->select('value');
                $this->builder->where('variable', 'payment_gateways_settings');
                $query = $this->builder->get()->getResultArray();
                if (count($query) == 1) {
                    $settings = $query[0]['value'];
                    $settings = json_decode($settings, true);
                    $this->data = array_merge($this->data, $settings);
                }


                $this->data['title'] = 'Payment Gateways Settings | Admin Panel';
                $this->data['main_page'] = 'payment_gateways';
                return view('backend/admin/template', $this->data);
            }
        } else {
            return redirect('admin/login');
        }
    }

    public function tts_settings()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }

                $updatedData = $this->request->getPost();
                $json_string = json_encode($updatedData);

                if ($this->update_setting('tts_config', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the text to speech configuratins.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'Text to Speech Configuratins has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/tts-settings')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'tts_config');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {
                if (!empty($query[0]['value'])) {

                    $settings = $query[0]['value'];
                    $settings = json_decode($settings, true);
                    $this->data = array_merge($this->data, $settings);
                }
            }

            $this->data['title'] = 'Text to Speech Settings | Admin Panel';
            $this->data['main_page'] = 'tts_config';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function privacy_policy()
    {

        if ($this->isLoggedIn && $this->userIsAdmin) {

            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }

                $updatedData = $this->request->getPost();
                unset($updatedData['update']);
                unset($updatedData['files']);
                unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('privacy_policy', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the privacy policy.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'privacy Policy has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/privacy-policy')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'privacy_policy');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {

                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);

                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'Privacy Policy Settings | Admin Panel';
            $this->data['main_page'] = 'privacy_policy';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }
    public function customer_privacy_policy_page()
    {
        $settings = get_settings('general_settings', true);
        $this->data['title'] = 'Privacy Policy | ' . $settings['company_title'];
        $this->data['meta_description'] = 'Privacy Policy | ' . $settings['company_title'];
        $this->data['privacy_policy'] = get_settings('customer_privacy_policy',true);
        $this->data['settings'] =  $settings;
        return view('backend/admin/pages/customer_app_privacy_policy', $this->data);
    }
    public function partner_privacy_policy_page()
    {
        $settings = get_settings('general_settings', true);
        $this->data['title'] = 'Privacy Policy | ' . $settings['company_title'];
        $this->data['meta_description'] = 'Privacy Policy | ' . $settings['company_title'];
        $this->data['privacy_policy'] = get_settings('privacy_policy',true);
        $this->data['settings'] =  $settings;
        return view('backend/admin/pages/partner_app_privacy_policy', $this->data);
    }

    public function customer_privacy_policy()
    {

        if ($this->isLoggedIn && $this->userIsAdmin) {

            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }

                $updatedData = $this->request->getPost();
                unset($updatedData['update']);
                unset($updatedData['files']);
                unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('customer_privacy_policy', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the privacy policy.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'privacy Policy has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/customer-privacy-policy')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'customer_privacy_policy');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {

                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);

                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'Privacy Policy Settings | Admin Panel';
            $this->data['main_page'] = 'customer_privacy_policy';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function refund_policy()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {

            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }

                $updatedData = $this->request->getPost();
                unset($updatedData['update']);
                unset($updatedData['files']);
                unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('refund_policy', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the refund policy.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'refund Policy has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/refund-policy')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'refund_policy');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {

                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);

                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'Refund Policy Settings | Admin Panel';
            $this->data['main_page'] = 'refund_policy';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }
    public function updater()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {


            $this->data['title'] = 'Updater | Admin Panel';
            $this->data['main_page'] = 'updater';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function terms_and_conditions()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }
                $updatedData = $this->request->getPost();
                unset($updatedData['files']);
                unset($updatedData['update']);
                unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('terms_conditions', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the terms & conditions.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'Terms & Conditions has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/terms-and-conditions')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'terms_conditions');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'Terms & Conditions Settings - Admin Panel | eDemand';
            $this->data['main_page'] = 'terms_and_conditions';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function customer_terms_and_conditions()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }

                $updatedData = $this->request->getPost();
                unset($updatedData['files']);
                unset($updatedData['update']);
                unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('customer_terms_conditions', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the terms & conditions.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'Terms & Conditions has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/customer-terms-and-conditions')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'customer_terms_conditions');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                $this->data = array_merge($this->data, $settings);
            }
            $this->data['title'] = 'Terms & Conditions Settings - Admin Panel | eDemand';
            $this->data['main_page'] = 'customer_terms_and_conditions';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function about_us()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }
                
                $updatedData = $this->request->getPost();
                unset($updatedData['files']);
                unset($updatedData['update']);
                  unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('about_us', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update about-us section.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'About-us section has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/about-us')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'about_us');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'About us Settings | Admin Panel';
            $this->data['main_page'] = 'about_us';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function contact_us()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }

                $updatedData = $this->request->getPost();
                unset($updatedData['files']);
                unset($updatedData['update']);
                unset($updatedData[csrf_token()]);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('contact_us', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update contact-us section.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'Contact-us section has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/contact-us')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'contact_us');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'Contact us Settings | Admin Panel';
            $this->data['main_page'] = 'contact_us';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function api_key_settings()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {

            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }

                $updatedData = $this->request->getPost();
                unset($updatedData['files']);
                unset($updatedData[csrf_token()]);
                unset($updatedData['update']);
                $json_string = json_encode($updatedData);
               

                if ($this->update_setting('api_key_settings', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update PAI key section.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = ' PAI key  section has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/api_key_settings')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'api_key_settings');
            $query = $this->builder->get()->getResultArray();
          
            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
              
             
               
                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'API key Settings | Admin Panel';
            $this->data['main_page'] = 'api_key_settings';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }
    private function update_setting($variable, $value)
    {
        $this->builder->where('variable', $variable);
        if (exists(['variable' => $variable], 'settings')) {
            $this->db->transStart();
            $this->builder->update(['value' => $value]);
            $this->db->transComplete();
        } else {
            $this->db->transStart();
            $this->builder->insert(['variable' => $variable, 'value' => $value]);
            $this->db->transComplete();
        }

        return $this->db->transComplete() ? true : false;
    }

    public function themes()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {
            if ($this->request->getPost('update')) {
            }
            $this->data["themes"] = fetch_details('themes', [], [], null, '0', 'id', "ASC");

            $this->data['title'] = 'About us Settings | Admin Panel';
            $this->data['main_page'] = 'themes';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function system_tax_settings()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {

            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }
                $updatedData = $this->request->getPost();
                unset($updatedData['files']);
                unset($updatedData[csrf_token()]);
                unset($updatedData['update']);
                $json_string = json_encode($updatedData);
            
                if ($this->update_setting('system_tax_settings', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update system tax settings.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = ' System Tax settings successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/system_tax_settings')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'system_tax_settings');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'System Tax Settings | Admin Panel';
            $this->data['main_page'] = 'system_tax_settings';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

    public function app_settings()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {

            if ($this->request->getPost('update')) {
                if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                    $response['error'] = true;
                    $response['message'] = DEMO_MODE_ERROR;
                    $response['csrfName'] = csrf_token();
                    $response['csrfHash'] = csrf_hash();
                    return $this->response->setJSON($response);
                }
                $updatedData = $this->request->getPost();
                unset($updatedData[csrf_token()]);
                unset($updatedData['update']);
                $json_string = json_encode($updatedData);

                if ($this->update_setting('app_settings', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update the App settings.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = 'App settings has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/app')->withCookies();
            }

            $this->builder->select('value');
            $this->builder->where('variable', 'app_settings');
            $query = $this->builder->get()->getResultArray();

            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'App Settings | Admin Panel';
            $this->data['main_page'] = 'app';
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }
    
    
    
        public function firebase_settings()
    {
        if ($this->isLoggedIn && $this->userIsAdmin) {

            if ($this->request->getPost('update')) {
                // if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
                //     $response['error'] = true;
                //     $response['message'] = DEMO_MODE_ERROR;
                //     $response['csrfName'] = csrf_token();
                //     $response['csrfHash'] = csrf_hash();
                //     return $this->response->setJSON($response);
                // }

                $updatedData = $this->request->getPost();
                
                
               
                unset($updatedData[csrf_token()]);
                unset($updatedData['update']);
                $json_string = json_encode($updatedData);
               
      
                if ($this->update_setting('firebase_settings', $json_string)) {
                    $_SESSION['toastMessage']  = 'Unable to update Firebase section.';
                    $_SESSION['toastMessageType']  = 'error';
                } else {
                    $_SESSION['toastMessage'] = ' Firebase has been successfuly updated.';
                    $_SESSION['toastMessageType']  = 'success';
                }
                $this->session->markAsFlashdata('toastMessage');
                $this->session->markAsFlashdata('toastMessageType');
                return redirect()->to('admin/settings/firebase_settings')->withCookies();
            }
            $this->builder->select('value');
            $this->builder->where('variable', 'firebase_settings');
            $query = $this->builder->get()->getResultArray();
            if (count($query) == 1) {
                $settings = $query[0]['value'];
                $settings = json_decode($settings, true);
                $this->data = array_merge($this->data, $settings);
            }

            $this->data['title'] = 'Firebase Settings | Admin Panel';
            $this->data['main_page'] = 'firebase_settings';
            
            // print_r($this->data);
            // die;
            return view('backend/admin/template', $this->data);
        } else {
            return redirect('admin/login');
        }
    }

}