<?php

namespace App\Controllers\partner;

use App\Models\Orders_model;

class Dashboard extends Partner
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        if ($this->isLoggedIn && $this->userIsPartner) {
            if (!exists(['partner_id' => $this->userId, 'is_approved' => 1], 'partner_details')) {
                return redirect('partner/profile');
            }
            $db = \Config\Database::connect();
            $id = $this->userId;
            $builder = $db->table('orders o');
            $order_count = $builder->select('count(DISTINCT(o.id)) as total')->where(['o.partner_id'=>$id])->get()->getResultArray();
            $total_services = $db->table('services s')->select('count(s.id) as `total`')->where(['user_id' => $id])->get()->getResultArray()[0]['total'];
            $total_balance = unsettled_commision($id);

            $total_ratings = $db->table('partner_details p')->select('count(p.ratings) as `total`')->where(['id' => $id])->get()->getResultArray()[0]['total'];
            $number_or_ratings = $db->table('partner_details p')->select('count(p.number_of_ratings) as `total`')->where(['id' => $id])->get()->getResultArray()[0]['total'];
            $income = $db->table('orders o')->select('count(o.id) as `total`')->where(['user_id' => $id])->where("created_at >= DATE(now()) - INTERVAL 7 DAY")->get()->getResultArray()[0]['total'];
            $symbol =   get_currency();
            $this->data['total_services'] = $total_services;
            $this->data['total_orders'] = $order_count[0]['total'];
            $this->data['total_balance'] =  number_format($total_balance, 2, ".", "");
            $this->data['total_ratings'] = $total_ratings;
            $this->data['number_of_ratings'] = $number_or_ratings;
            $this->data['currency'] = $symbol;
            $this->data['income'] = number_format($income, 2, ".", "");
            $this->data['title'] = 'Dashboard | Partner Panel';
            $this->data['main_page'] = 'dashboard';

            return view('backend/partner/template', $this->data);
        } else {
            return redirect('partner/login');
        }
    }

    public function fetch_sales()
    {
        if (!$this->isLoggedIn) {
            return redirect('partner/login');
        } else {
            $sales[] = array();
            $db = \Config\Database::connect();

            $month_res = $db->table('orders')
                ->select('SUM(final_total) AS total_sale,DATE_FORMAT(created_at,"%b") AS month_name ')
                ->where('partner_id', $_SESSION['user_id'])
                ->groupBy('year(CURDATE()),MONTH(created_at)')
                ->orderBy('year(CURDATE()),MONTH(created_at)')
                ->get()->getResultArray();

            $month_wise_sales['total_sale'] = array_map('intval', array_column($month_res, 'total_sale'));
            $month_wise_sales['month_name'] = array_column($month_res, 'month_name');

            $sales = $month_wise_sales;
            print_r(json_encode($sales));
        }
    }

    public function fetch_data()
    {
        $db = \Config\Database::connect();
        $id = $this->userId;
        $res = $db->table('categories as c')
            ->select('c.name as category,count(c.id) as counter')
            ->join('services s', 's.category_id=c.id ')
            ->where(['s.user_id' => $id, 's.status' => '1', 'c.status' => '1'])
            ->groupBy('c.id')
            ->get()->getResultArray();
        $response['category'] = array_column($res, 'category');
        $response['counter'] = array_column($res, 'counter');
        print_r(json_encode($response));
    }
}
