<?php

namespace App\Models;

use CodeIgniter\Model;

class Slider_model extends Model
{
    protected $DBGroup = 'default';
    protected $table = 'sliders';
    protected $primaryKey = 'id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = true;

    protected $allowedFields = ['type', 'type_id', 'image', 'status'];
    protected $useTimestamps = true;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public $base, $admin_id, $db;



    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'sl.id', $order = 'ASC', $where = [])
    {
        $multipleWhere = '';
        $db      = \Config\Database::connect();
        $condition = "";
        $builder = $db->table('sliders sl');
        $sortable_fields = ['id' => 'id', 'type' => 'type', 'type_id' => 'type_id', 'status' => 'status'];

        if (isset($search) and $search != '') {
            $multipleWhere = ['`sl.id`' => $search, '`sl.type`' => $search, '`sl.status`' => $search];
        }
        if ($from_app) {
            $where['sl.status'] = 1;
        }
        $total  = $builder->select(' COUNT(id) as `total` ');
        if (isset($_GET['id']) && $_GET['id'] != '') {
            $builder->where($condition);
        }

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orWhere($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        $slider_count = $builder->get()->getResultArray();
        $total = $slider_count[0]['total'];

        $builder->select('sl.*,c.name as category_name,s.title as service_name');
        
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->orLike($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }

        $slider_record = $builder->join('categories c', 'c.id=sl.type_id', 'left')->join('services s', 's.id=sl.type_id', 'left')->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
        // print_R($slider_record);
        // return;

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($slider_record as $row) {
            if ($from_app == false) {
                if (check_exists(base_url('/public/uploads/sliders/' . $row['image']))) {
                    $image = '<a  href="' . base_url('/public/uploads/sliders/' . $row['image'])  . '" data-lightbox="image-1"><img height="80px" width="80px" class="rounded" src="' . base_url("/public/uploads/sliders/" . $row['image']) . '" alt=""></a>';
                } else {
                    $image = 'nothing found';
                }
            } else {

                if (check_exists(base_url('/public/uploads/sliders/' . $row['image']))) {
                    $image = base_url('/public/uploads/sliders/' . $row['image']);
                } else {
                    $image = 'nothing found';
                }
            }
            $operations = '
                <button class="btn btn-success edite-slider" data-id="' . $row['id'] . '"  data-toggle="modal" data-target="#update_modal" onclick="update_slider(this)"
                title = "Update the slider"> <i class="fa fa-pen" aria-hidden="true"></i> </button>  
                <button class="btn btn-danger delete-slider" data-id="' . $row['id'] . '" data-toggle="modal" data-target="#delete_modal" onclick="category_id(this)"title = "Delete the slider"> <i class="fa fa-trash" aria-hidden="true"></i> </button> 
            ';

            $status =  ($row['status'] == 1) ? 'Enable' : 'Disable';

            $tempRow['id'] = $row['id'];

            $tempRow['type'] = $row['type'];
            $tempRow['type_id'] = $row['type_id'];
            $tempRow['slider_image'] = $image;
            $tempRow['category_name'] = isset($row['category_name']) ?$row['category_name'] : '';
            $tempRow['service_name'] = isset($row['service_name']) ?$row['service_name'] : '';

            if ($from_app == false) {
                $tempRow['status'] = ($row['status'] == 1) ? "<label class='badge badge-success'>Active</label>" : "<label class='badge badge-danger'>Deactive</label>";
                $tempRow['og_status'] = $row['status'];
                $tempRow['operations'] = $operations;
            }
            if ($from_app == false) {
                $tempRow['created_at'] = $row['created_at'];
            }
            $rows[] = $tempRow;
        }

        if ($from_app) {
            // if request from app return array 
            $data['total'] = $total;
            $data['data'] = $rows;
            return $data;
        } else {
            // else return json
            $bulkData['rows'] = $rows;
            return json_encode($bulkData);
        }
    }
}
