<div class="main-content">

    <section class="section">
        <div class="section-header">
            <h1><?= labels('featured_section', "Featured Section") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><?= labels('featured_section', "Featured Section") ?></a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <h2 class='section-title'><?= labels('create_featured_section', "Create Featured Section") ?></h2>
                        <?= form_open('/admin/featured_sections/add_featured_section', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_featured_section', 'enctype' => "multipart/form-data"]); ?>
                        <div class="form-group">
                            <label for="name"><?= labels('title', "Title") ?></label>
                            <input id="title" class="form-control" type="text" name="title" placeholder="<?= labels('enter', "Enter") ?> <?= labels('title', "Title") ?>">
                        </div>
                    </div>


                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="service"><?= labels('section_types', "Section Types") ?></label>
                            <select id="section_type" class="form-control" name="section_type">
                                <option value=" "><?= labels('section_types', "Section Types") ?></option>
                                <option value="categories"><?= labels('categories', "Categories") ?></option>
                                <option value="partners"><?= labels('custom_provider', "Custom Provider ") ?> </option>
                                <option value="top_rated_partner"><?= labels('top_rated_provider ', "Top Rated Provider") ?> </option>
                                <!-- <option value="top_rated_service"><?= labels('top_rated_service Rated', "Top Rated Service") ?>  </option> -->
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group Category_item d-none">
                            <label for="feature_category_item"><?= labels('categories', "Categories") ?></label> <br>
                            <select id="feature_category_item" class="" name="category_item[]" multiple>
                                <?php foreach ($categories_name as $Category) : ?>
                                    <option value="<?= $Category['id'] ?>"><?= $Category['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group top_rated_providers d-none">
                            <label for="top_rated_provider"><?= labels('no_of_top_rated_provider_to_show', "No. of Top Rated Provider to show") ?></label> <br>
                            <div class="form-group">
                                <input id="limit" class="form-control" type="number" name="limit" placeholder="Enter Number of Provider you want to show">
                            
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">

                    <div class="col-md-4">
                        <div class="form-group partners_ids d-none">
                            <label for="partners_ids"><?= labels('custom_provider', "Custom Provider ") ?> </label> <br>
                            <select id="partners_ids" class="form-control" name="partners_ids[]" multiple>
                                <?php foreach ($partners as $partner) : ?>
                                    <option value="<?= $partner['partner_id'] ?>"><?= $partner['company_name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Status<span class="text-danger text-sm">*</span></label>
                            <br>
                            <div id="status" class="btn-group col-sm-8" style="margin-left: -11px;">
                                <label class="btn btn-primary" data-toggle-class="btn-primary" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="status" value="1">Active </label>
                                <label class="btn btn-danger" data-toggle-class="btn-danger" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="status" value="0" checked=""> Deactive </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <button type="reset" class="btn btn-warning"><?= labels('Reset', "Reset") ?> </button>
                        <button type="submit" class="btn btn-success"><?= labels('add_section', "Add Section") ?></button>
                        <?= form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid card">
            <h2 class='section-title'><?= labels('featured_section', "Featured Section") ?></h2>
            <div class="row">
                <div class="col-lg">
                    <div class="card-body">
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="col-md">
                                    <table class="table table-striped" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/featured_sections/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                                        <thead>
                                            <tr>
                                                <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                                <th data-field="title" class="text-center" data-sortable="true"><?= labels('title', 'Title') ?></th>
                                                <th data-field="category_ids" class="text-center" data-visible="false" data-sortable="true"><?= labels('category_id', 'Category id') ?></th>
                                                <th data-field="section_type" class="text-center" data-sortable="true"><?= labels('section', 'Section Type') ?></th>
                                                <th data-field="partners_ids" class="text-center" data-visible="false" data-sortable="true"><?= labels('provider_id', 'Provider Id') ?></th>
                                                <th data-field="created_at" class="text-center" data-sortable="true"><?= labels('created_at', 'Created At') ?></th>
                                                <th data-field="status_badge" class="text-center"><?= labels('status', 'Status') ?></th>

                                                <th data-field="operations" class="text-center" data-events="featured_section_events"><?= labels('operations', 'Operations') ?></th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- update modal -->
    <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Featured Section</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- <form action="" method="post"> -->
                    <?= form_open('admin/featured_sections/update_featured_section', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'edit_feature', 'enctype' => "multipart/form-data"]); ?>
                    <input type="hidden" name="id" id="id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="title"><?= labels('title', "Title") ?></label>
                                <input id="edit_title" class="form-control" type="text" name="title" placeholder="Enter the title here">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="service"><?= labels('section_types', "Section Types") ?></label>
                                <select id="edit_section_type" class="form-control" name="section_type">
                                    <option value=" "><?= labels('section_types', "Section Types") ?></option>
                                    <option value="categories"><?= labels('categories', "Categories") ?></option>
                                    <option value="partners"><?= labels('custom_provider', "Custom Provider ") ?></option>
                                    <option value="top_rated_partner"><?= labels('top_rated_provider ', "Top Rated Provider") ?> </option>
                                    <!-- <option value="top_rated_service"><?= labels('top_rated_service Rated', "Top Rated Service") ?> </option> -->
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label>Status<span class="text-danger text-sm">*</span></label>
                                <br>
                                <div id="edit_status" class="btn-group col--8" style="margin-left: -11px;">
                                    <label class="btn btn-primary" data-toggle-class="btn-primary" data-toggle-passive-class="btn-default">
                                        <input type="radio" id="edit_status_active" name="edit_status" value="1">Active </label>
                                    <label class="btn btn-danger" data-toggle-class="btn-danger" data-toggle-passive-class="btn-default">
                                        <input type="radio" id="edit_status_deactive" name="edit_status" value="0" checked=""> Deactive </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group edit_category_item d-none">
                                <label for="name"><?= labels('categories', "Categories") ?></label> <br>
                                <select id="edit_Category_item" class="form-control" name="edit_Category_item[]" multiple>
                                    <?php foreach ($categories_name as $Category) : ?>
                                        <option value="<?= $Category['id'] ?>"><?= $Category['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group edit_partners_ids d-none">
                                <label for="name"><?= labels('provider', "Provider") ?></label>
                                <select id="edit_partners_ids" class="form-control" name="edit_partners_ids[]" multiple>

                                    <?php foreach ($partners as $partner) : ?>
                                        <option value="<?= $partner['partner_id'] ?>"><?= $partner['company_name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" name="submit"><?= labels('update_section', "Update Section") ?></button>
                    <?php form_close() ?>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= labels('close', "Close") ?></button>
                </div>
            </div>
        </div>
    </div>
</div>