<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('notification', "Notification") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><?= labels('notification', 'Notification') ?></div>
            </div>
        </div>
        <div class="container-fluid card">
            <?= helper('form'); ?>
            <div class="row">
                <div class="col-md">
                    <h2 class='section-title'><?= labels('send_notifications', "Send Notification") ?></h2>
                    <div class="card-body">
                        <?= form_open('/admin/notification/add_notification', [
                            'method' => "post", 'class' => 'form-submit-event',
                            'id' => 'add_notification', 'enctype' => "multipart/form-data"
                        ]); ?>





                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="type"><?= labels('send', "Send") ?> <?= labels('to', "To") ?> </label>
                                    <select id="user_type" class="form-control" name="user_type">
                                        <!-- <option value=""><?= labels('select_type', "Select Type") ?> </option> -->
                                        <option value="all_users" selected><?= labels('all_users', "All Users") ?> </option>
                                        <option value="specific_user"><?= labels('specific_user', "Specific User") ?></option>
                                        <option value="provider"><?= labels('provider', "Provider") ?></option>
                                        <option value="customer"><?= labels('customer', "Customer") ?></option>


                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="row" id="user_select">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="personal">
                                        <label for="Category_item"><?= labels('personal', "Personal") ?></label>
                                        <select id="users" class="form-control" name="user_ids[]" multiple>
                                            <?php foreach ($users as $user) : ?>
                                                <option value="<?= $user['id'] ?>"><?= $user['username'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="type"><?= labels('type', "Type") ?> <?= labels('notification', "Notification") ?> </label>
                                    <select id="type1" class="form-control" name="type">
                                        <option value=""><?= labels('select_type', "Select Type") ?> </option>
                                        <!-- <option value="personal"><?= labels('personal', "Personal") ?> </option> -->
                                        <option value="general"><?= labels('general', "General") ?></option>
                                        <option value="provider"><?= labels('provider', "Provider") ?></option>
                                        <option value="category"><?= labels('category', "Category") ?></option>
                                        <option value="url"><?= labels('url', "URL") ?></option>

                                    </select>
                                </div>
                            </div>

                        </div>




                        <div class="row" id="provider_select">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="per">
                                        <label for="Category_item"><?= labels('provider', "Provider") ?></label>
                                        <select id="providers" class="form-control select2 select2-hidden-accessible" name="partner_id">
                                            <?php foreach ($partners as $partner) : ?>
                                                <option value="<?= $partner['partner_id'] ?>"><?= $partner['company_name'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row" id="category_select">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="per">
                                        <label for="Category_item"><?= labels('category', "Category") ?></label>
                                        <select id="categories" class="form-control select2 select2-hidden-accessible" name="category_id">
                                            <?php foreach ($categories_name as $categorie) : ?>
                                                <option value="<?= $categorie['id'] ?>"><?= $categorie['name'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row" id="url">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="per">
                                        <label for="Category_item"><?= labels('url', "URL") ?></label>
                                        <input id="url" class="form-control" type="url" name="url" placeholder="Enter the URL here">
                                    </div>
                                </div>
                            </div>
                        </div>




                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="title"><?= labels('title', "Title") ?></label>
                                    <input id="title" class="form-control" type="title" name="title" placeholder="Enter the title here">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="message"><?= labels('message', "Message") ?></label>
                                    <textarea id="messgae" class="form-control col-md-12" name="message" placeholder="Enter The message Here"></textarea>
                                </div>
                            </div>
                        </div>


                        <!-- <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="input-group mb-3">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="Image" name="image" aria-describedby="notification_image">
                                            <label class="custom-file-label" for="image"><?= labels('choose_file', "Choose file") ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                        <div class="row">

                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="checkbox" name="image_checkbox" id="image_checkbox">
                                    <span>Include Image</span>
                                </div>
                            </div>
                            <div class="col-md-12 d-none include_image">
                                <label for="message">Image</label>
                               

                                    <div class="file-upload">
                                        <div class="file-select" style="border-radius: 0.25rem;">
                                            <div class="file-select-button" id="fileName"><?= labels('choose_file', 'Choose File') ?></div>
                                            <div class="file-select-name" id="noFile"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                            <input type="file" name="image" id="image" accept="image/*" onchange="readURL(this)">
                                        </div>
                                    </div>
                                   
                                    <div id="category_image_section">
                                        <div id="categoryImage" style="width: 200px; height: 150px; ">
                                            <div class="form-group image">
                                                <img src="<?= base_url('public/backend/assets/img/news/img01.jpg') ?>" style="display: block;margin-top: 25px;margin-right: auto;width: 80%;" alt="category Image" width="50%" height="100px" id="service_image">
                                            </div>
                                        </div>
                                    </div>
                                
                            </div>
                        </div>

                    
                    <!-- <div class="col-md-4">
                            <div class="form-group"> <label for="image"><?= labels('image', 'Image') ?></label>
                                <div class="file-upload">
                                    <div class="file-select" style="border-radius: 0.25rem;">
                                        <div class="file-select-button" id="fileName"><?= labels('choose_file', 'Choose File') ?></div>
                                        <div class="file-select-name" id="noFile"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                        <input type="file" name="image" id="image" accept="image/*" onchange="readURL(this)">
                                    </div>
                                </div>
                            </div>
                        </div> -->





                    <div class="row">
                        <div class="col-md">
                            <div class="form-group">
                                <button type="reset" class="btn btn-warning"><?= labels('Reset', "Reset") ?></button>
                                <button type="submit" class="btn btn-success"><?= labels('send_notifications', "Send Notification") ?></button>
                            </div>
                        </div>
                    </div>
                    <?= form_close(); ?>
                </div>
            </div>
        </div>
</div>
<div class="container-fluid card">
    <h2 class='section-title'><?= labels('notification_details', "Notification details") ?></h2>
    <div class="row">
        <div class="col-lg">
            <table class="table table-striped" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/notification/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                <thead>
                    <tr>
                        <th data-field="id" class="text-center" data-visible="true" data-sortable="true"><?= labels('id', 'ID') ?></th>
                        <th data-field="title" class="text-center" data-visible="true"><?= labels('title', 'Title') ?></th>
                        <th data-field="message" class="text-center" data-visible="true"><?= labels('message', 'Message') ?></th>
                        <th data-field="image" class="text-center"><?= labels('image', 'Image') ?></th>
                        <th data-field="type" class="text-center" data-visible="true" data-sortable="true"><?= labels('type', 'Type') ?></th>
                        <th data-field="notification_type" class="text-center" data-visible="true" data-sortable="true"><?= labels('notification_type', 'Notification Type') ?></th>
                        <th data-field="operations" class="text-center" data-events="notification_event"><?= labels('operations', 'Operations') ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
</section>
</div>