<div class="main-content profile-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('my_profile', "My Profile") ?></h1>
        </div>
        <?php if (empty($partner_details)) { ?>
            <div class="alert alert-info" role="alert">
                Please Complete Your KYC Then you can Access Panel
            </div>
        <?php } else if ($partner_details['is_approved'] == "0") { ?>
            <div class="alert alert-primary" role="alert">
                Your KYC request is pending please wait for admin action.
            </div>
        <?php } else if ($partner_details['is_approved'] == "2") { ?>
            <div class="alert alert-danger" role="alert">
                Your KYC request is Rejected by Admin Please try again.
            </div>
        <?php }  ?>

        <div class="section-body">
            <div class="row mt-sm-4">
                <div class="col-md-12">
                    <div class="card">
                        <?= form_open('/partner/update_profile', ['method' => "post", 'class' => 'form-submit-event', 'enctype' => "multipart/form-data"]); ?>
                        <div class="card-header">
                            <h4><?= labels('edit_profile', "Edit Profile") ?></h4>
                        </div>
                        <div class="card-body">
                            <h2 class='section-title'><?= labels('provider_details', "Provider Details") ?></h2>

                            <div class="row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Username</label>
                                        <input class="form-control" type="text" name="username" value="<?= $data['username'] ?>">
                                    </div>

                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for=""><?= labels('type', 'Type') ?></label>
                                        <select name="type" id="" class="form-control">
                                            <option value="0" <?= ($partner_details['type'] == 0) ? 'selected' : '' ?>><?= labels('individual', 'Individual') ?> </option>
                                            <option value="1" <?= ($partner_details['type'] == 1) ? 'selected' : '' ?>><?= labels('organization', 'Organization') ?></option>
                                        </select>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md">
                                    <div class="form-group">
                                        <label for=""><?= labels('about_provider', 'About Provider') ?></label>
                                        <textarea type="text" class="form-control" value="" name="about" rows=""><?= $partner_details['about'] ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for=""><?= labels('visiting_charges', 'Visiting Charges') ?> </label>
                                        <input type="number" class="form-control" value="<?= $partner_details['visiting_charges'] ?>" name="visiting_charges" min="0">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for=""> <?= labels('advance_booking_days', 'Advance Booking Days') ?></label>

                                        <input type="text" class="form-control" value="<?= $partner_details['advance_booking_days'] ?>" name="advance_booking_days">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="number_of_members"><?= labels('number_Of_members', 'Number of Members') ?></label>
                                        <input id="number_of_members" class="form-control" type="text" value="<?= $partner_details['number_of_members'] ?>" name="number_of_members" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('number_Of_members', 'Number of Members') ?> <?= labels('here', ' Here ') ?>" required>
                                    </div>
                                </div>

                            </div>


                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""><?= labels('email', 'Email') ?></label>
                                        <input type="email" name="email" value="<?= $data['email'] ?>" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""><?= labels('phone_number', 'Phone Number') ?></label>
                                        <input type="number" name="phone" value="<?= $data['phone'] ?>" class="form-control" min="0" readonly>
                                    </div>
                                </div>
                            </div>




                            <div class="row mt-2">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image"><?= labels('image', 'Image') ?> </label>

                                        <div class="file-upload">
                                            <div class="file-select">
                                                <div class="file-select-button" id="fileName5"><?= labels('choose_file', 'Choose File') ?></div>
                                                <div class="file-select-name" id="noFile5"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                                <input type="file" name="image" id="image" accept="image/*" value="<?= $data['image']; ?>">
                                            </div>
                                        </div>
                                        <div class="">
                                            <a href="<?= !empty($data) && !empty($data['image']) ? base_url($data['image']) : "" ?>" data-lightbox="image-1">
                                                <img class="" style="margin-top: 25px;" width="200px" height="200px" src="<?= !empty($data) && !empty($data['image']) ? base_url($data['image']) : "" ?>" alt="no image "></a>
                                        </div>
                                        <!-- <input type="file" class="form-control mt-2" name="image" id="image" value="<?= $data['image']; ?>" placeholder="" min="1"> -->
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="banner"><?= labels('banner_image', 'Banner Image') ?></label>


                                        <div class="file-upload">
                                            <div class="file-select">
                                                <div class="file-select-button" id="fileName5"><?= labels('choose_file', 'Choose File') ?></div>
                                                <div class="file-select-name" id="noFile6"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                                <input type="file" name="banner" id="banner" accept="image/*" value="<?= $data['image']; ?>">
                                            </div>
                                        </div>
                                        <div class="">
                                            <a href="<?= !empty($partner_details) && !empty($partner_details['banner']) ? base_url($partner_details['banner']) : "" ?>" data-lightbox="image-1">
                                                <img class="" style="margin-top: 25px;" width="200px" height="200px" src="<?= !empty($partner_details) && !empty($partner_details['banner']) ? base_url($partner_details['banner']) : "" ?>" alt=""></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <h2 class='section-title'><?= labels('provider_location_information', "Location Information") ?></h2>
                            <div class="row">
                                <div class="col-md-6">

                                    <div id="map_wrapper_div">
                                        <div id="map"></div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for=""><?= labels('current_location', 'Current Location') ?></label>
                                            <input id="city_search" class="form-control" type="text" name="places">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="cities" id="cities_select">
                                                <label for="city"><?= labels('city', 'City') ?></label>
                                                <input type="text" name="city" class="form-control" value="<?= $data['city'] ?>" placeholder="<?= labels('enter_your_providers_city_name', 'Enter your provider\'s city name') ?>" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for=""><?= labels('latitude', 'Latitude') ?></label>
                                            <input type="text" class="form-control" name="latitude" id="latitude" value="<?= $data['latitude'] ?>" readonly>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for=""><?= labels('longitude', 'Longitude') ?></label>
                                            <input type="text" class="form-control" name="longitude" id="longitude" value="<?= $data['longitude'] ?>" readonly>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for=""><?= labels('address', 'Address') ?></label>
                                            <textarea name="address" value="<?= $partner_details['address'] ?>" class="form-control"><?= $partner_details['address'] ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h2 class='section-title'><?= labels('working_days', 'Working Days') ?></h2>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">

                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0"><?= labels('monday', 'Monday') ?></label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[0]['opening_time']) ? $partner_timings[0]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3 endTime">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[0]['closing_time']) ? $partner_timings[0]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[0]['is_open']) && $partner_timings[0]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="monday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="monday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0"> <?= labels('tuesday', 'Tuesday') ?></label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[1]['opening_time']) ? $partner_timings[1]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3 endTime">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[1]['closing_time']) ? $partner_timings[1]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[1]['is_open']) && $partner_timings[1]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="tuesday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="tuesday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0"> <?= labels('wednesday', 'Wednesday') ?></label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[2]['opening_time']) ? $partner_timings[2]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3 endTime">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[2]['closing_time']) ? $partner_timings[2]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[2]['is_open']) && $partner_timings[2]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="wednesday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="wednesday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0"> <?= labels('thursday', 'Thursday') ?></label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[3]['opening_time']) ? $partner_timings[3]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3 endTime">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[3]['closing_time']) ? $partner_timings[3]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[3]['is_open']) && $partner_timings[3]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="thursday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="thursday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0"> <?= labels('friday', 'Friday') ?></label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[4]['opening_time']) ? $partner_timings[4]['opening_time'] : '') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3 endTime">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[4]['closing_time']) ? $partner_timings[4]['closing_time'] : '') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[4]['is_open']) && $partner_timings[4]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="friday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="friday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0"> <?= labels('saturday', 'Saturday') ?></label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[5]['opening_time']) ? $partner_timings[5]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3 endTime">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[5]['closing_time']) ? $partner_timings[5]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[5]['is_open']) && $partner_timings[5]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="saturday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="saturday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for="0"> <?= labels('sunday', 'Sunday') ?></label>
                                            </div>
                                            <div class="col-md-3 ">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= (isset($partner_timings[6]['opening_time']) ? $partner_timings[6]['opening_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3 endTime">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= (isset($partner_timings[6]['closing_time']) ? $partner_timings[6]['closing_time'] : '0') ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <?php if (isset($partner_timings[6]['is_open']) && $partner_timings[6]['is_open'] == 1) : ?>
                                                        <input class="check_box check_box" type="checkbox" name="sunday" checked id="flexCheckDefault">
                                                    <?php else : ?>
                                                        <input class="check_box check_box" type="checkbox" name="sunday" id="flexCheckDefault">
                                                    <?php endif; ?>
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- <?php $days = [
                                            0 => 'monday',
                                            1 => 'tuesday',
                                            2 => 'wednesday',
                                            3 => 'thursday',
                                            4 => 'friday',
                                            5 => 'saturday',
                                            6 => 'sunday'
                                        ]; ?>
                                <div class="col-md-6">
                                    <label for="">Working Days</label>
                                    <?php foreach ($days as $day) {
                                        foreach ($partner_timings as $time) { ?>
                                        <div class="row mb-3">
                                            <div class="col-md-2">
                                                <label for=""><?= $day ?></label>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control start_time" name="start_time[]" value="<?= $time['opening_time'] ?>">
                                            </div>
                                            <div class="col-md-1 text-center mt-2">
                                                <?= labels('to', 'To') ?>
                                            </div>
                                            <div class="col-md-3">
                                                <input type="time" class="form-control end_time" name="end_time[]" value="<?= $time['closing_time'] ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-check mt-2">
                                                    <input class="check_box check_box" type="checkbox" name="<?= $time['day'] ?>" <?= ($time['is_open'] == 1) ? 'checked' : '' ?> id="flexCheckDefault">
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        <?= labels('open', 'Open') ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    <?php }
                                    } ?>
                                </div> -->
                            </div>
                            <hr>


                            <h2 class='section-title'><?= labels('ID_Proofs', 'ID Proofs') ?></h2>

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="banner_image"><?= labels('national_id', 'National ID') ?></label><br>
                                        <div class="file-upload">
                                            <div class="file-select">
                                                <div class="file-select-button" id="fileName2"><?= labels('choose_file', 'Choose File') ?></div>
                                                <div class="file-select-name" id="noFile2"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                                <input type="file" name="national_id" id="national_id" accept="image/*">
                                            </div>
                                        </div>
                                        <?php
                                        if (isset($partner_details['national_id']) && !empty($partner_details['national_id'])) {
                                        ?>
                                            <img src="<?= base_url($partner_details['national_id']) ?>" style="margin-top: 25px;" width="200px" height="200px" alt="">
                                        <?php
                                        } ?>

                                    </div>

                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="address_id"><?= labels('address_id', 'Address Identity') ?></label>
                                        <div class="file-upload">
                                            <div class="file-select">
                                                <div class="file-select-button" id="fileName3"><?= labels('choose_file', 'Choose File') ?></div>
                                                <div class="file-select-name" id="noFile3"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                                <input type="file" name="address_id" id="address_id" accept="image/*">
                                            </div>
                                        </div>
                                        <?php
                                        if (isset($partner_details['address_id']) && !empty($partner_details['address_id'])) {
                                        ?>
                                            <img src="<?= base_url($partner_details['address_id']) ?>" style="margin-top: 25px;" width="200px" height="200px" alt="no file">
                                        <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="passport"><?= labels('passport', 'Passport') ?></label>
                                        <div class="file-upload">
                                            <div class="file-select">
                                                <div class="file-select-button" id="fileName4"><?= labels('choose_file', 'Choose File') ?></div>
                                                <div class="file-select-name" id="noFile4"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                                <input type="file" name="passport" id="passport" accept="image/*">
                                            </div>
                                        </div>
                                        <?php
                                        if (isset($partner_details['passport']) && !empty($partner_details['passport'])) {
                                        ?>
                                            <img src="<?= base_url($partner_details['passport']) ?>" style="margin-top: 25px;" width="200px" height="200px" alt="">
                                        <?php
                                        }
                                        ?>


                                    </div>

                                </div>
                            </div>
                            <h2 class='section-title'><?= labels('bank_details', 'Bank Details') ?></h2>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="tax_name"><?= labels('tax_name', 'Tax Name') ?></label>
                                        <input id="tax_name" class="form-control" value="<?= $partner_details['tax_name'] ?>" type="text" name="tax_name" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('tax_name', 'Tax Name') ?> <?= labels('here', ' Here ') ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="tax_number"><?= labels('tax_number', 'Tax Number') ?></label>
                                        <input id="tax_number" class="form-control" value="<?= $partner_details['tax_number'] ?>" type="text" name="tax_number" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('tax_number', 'Tax Number') ?> <?= labels('here', ' Here ') ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for=""><?= labels('account_number', 'Account Number') ?></label>
                                        <input type="text" name="account_number" value="<?= $partner_details['account_number'] ?>" class="form-control" id="">
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for=""><?= labels('account_name', 'Account Name') ?></label>
                                        <input type="text" name="account_name" value="<?= $partner_details['account_name'] ?>" class="form-control" id="">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for=""><?= labels('bank_code', 'Bank Code') ?></label>
                                        <input type="text" name="bank_code" value="<?= $partner_details['bank_code'] ?>" class="form-control" id="">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for=""><?= labels('bank_name', 'Bank Name') ?></label>
                                        <input type="text" name="bank_name" value="<?= $partner_details['bank_name'] ?>" class="form-control" id="">
                                    </div>
                                </div>



                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="swift_code"><?= labels('swift_code', 'Swift Code') ?></label>
                                        <input id="swift_code" class="form-control" value="<?= $partner_details['swift_code'] ?>" type="text" name="swift_code" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('swift_code', 'Swift Code') ?> <?= labels('here', ' Here ') ?>" required>
                                    </div>
                                </div>
                            </div>



                            <div class="row mt-3">
                                <div class="col-md-12">
                                    <button class="btn btn-lg btn-primary" type="submit">Update</button>
                                    <button type="button" onclick="test()" class=" btn btn-lg btn-warning"><?= labels('Reset', 'Reset') ?></button>
                                    <?= form_close() ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
    </section>
</div>

<script>
    $('#national_id').bind('change', function() {
        var filename = $("#national_id").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile2").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile2").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#address_id').bind('change', function() {
        var filename = $("#address_id").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile3").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile3").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#passport').bind('change', function() {
        var filename = $("#passport").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile4").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile4").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#image').bind('change', function() {
        var filename = $("#image").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile5").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile5").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#banner').bind('change', function() {
        var filename = $("#banner").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile6").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile6").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('.start_time').change(function() {
        var doc = $(this).val();
        console.log(doc);
        $(this).parent().siblings(".endTime").children().attr('min', doc);

    });

    function test() {
        document.querySelectorAll('.form-control').forEach(function(a) {
            a.removeAttribute('value')
        })
    }
</script>